class MD5
{
	/* 
	 * Java bitwise operators: 
	 * 
	 * ^ is XOR, & is AND, ~ is NOT and | is OR
	 * 
	 * <<< or << is left shift (equivalent to multiplication by powers of 2)
	 * >>> or >> is right shift (equivalent to division by powers of 2)
	 * 
	*/
	
	private static final int INIT_A = 0x67452301;
	private static final int INIT_B = (int)0xEFCDAB89L;
	private static final int INIT_C = (int)0x98BADCFEL;
	private static final int INIT_D = 0x10325476;

	private static final int[] SHIFT_AMTS = {7, 12, 17, 22, 5,  9, 14, 20, 4, 11, 16, 23, 6, 10, 15, 21 };

	private static final int[] TABLE_T = new int[64];
	static {
		for (int i = 0; i < 64; i++)
			TABLE_T[i] = (int)(long)((1L << 32) * Math.abs(Math.sin(i + 1)));
	}

	public static byte[] computeMD5(byte[] message) {
		int messageLenBytes = message.length;
		// Divide by 512 (=2^6) to get number of 512-bit blocks
		int numBlocks = ((messageLenBytes + 8) >>> 6) + 1;
		// Total length of buffer, including padding (multiply by 2^6=512)
		int totalLen = numBlocks << 6;
		// Create buffer for padding bytes
		byte[] paddingBytes = new byte[totalLen - messageLenBytes];
		// The first padding bit is 1
		paddingBytes[0] = (byte)0x80;
		// divide length in bytes by 8 (=2^3) to get length in bits
		long messageLenBits = (long)messageLenBytes << 3;
		// the last 8 bytes of padding are filled with the message length
		for (int i = 0; i < 8; i++) {
			paddingBytes[paddingBytes.length - 8 + i] = (byte)messageLenBits;
			messageLenBits >>>= 8;
		}
		// initialize the state
		int a = INIT_A;
		int b = INIT_B;
		int c = INIT_C;
		int d = INIT_D;
		int[] buffer = new int[16];
		// process each block
		for (int i = 0; i < numBlocks; i ++) {
			// the index in bytes
			int index = i << 6;
			// divide into chunks of 32 bits
			for (int j = 0; j < 64; j++, index++)
				buffer[j >>> 2] = ((int)((index < messageLenBytes) ? message[index] 
						: paddingBytes[index - messageLenBytes]) << 24) | (buffer[j >>> 2] >>> 8);
			int originalA = a;
			int originalB = b;
			int originalC = c;
			int originalD = d;
			// run 64 rounds
			for (int j = 0; j < 64; j++) {
				// div16 is j divided by 16 and indicates the stage (and which function f to use) 
				int div16 = j >>> 4;
				int f = 0;
				int bufferIndex = j;
				// in each round, apply a different function f
				switch (div16) {
				case 0:
					f = (b & c) | (~b & d);
					break;
				case 1:
					f = (b & d) | (c & ~d);
					bufferIndex = (bufferIndex * 5 + 1) & 0x0F;
					break;
				case 2:
					f = b ^ c ^ d;
					bufferIndex = (bufferIndex * 3 + 5) & 0x0F;
					break;
				case 3:
					f = c ^ (b | ~d);
					bufferIndex = (bufferIndex * 7) & 0x0F;
					break;
				}
				int temp = b + Integer.rotateLeft(a + f + buffer[bufferIndex] + TABLE_T[j], SHIFT_AMTS[(div16 << 2) | (j & 3)]);
				a = d;
				d = c;
				c = b;
				b = temp;
			}
			a += originalA;
			b += originalB;
			c += originalC;
			d += originalD;
		}
		byte[] md5 = new byte[16];
		int count = 0;
		for (int i = 0; i < 4; i++) {
			int n = (i == 0) ? a : ((i == 1) ? b : ((i == 2) ? c : d));
			for (int j = 0; j < 4; j++) {
				md5[count++] = (byte)n;
				n >>>= 8;
			}
		}
		return md5;
	}	
}
