public class Pearson {

	/*
	 * The lookup Table t should be some random permutation, not the ordered sequence
	 */
	private static byte[] T = new byte[256];
	static {
		for (byte b=Byte.MIN_VALUE; b<Byte.MAX_VALUE; b++) T[b-Byte.MIN_VALUE]=b;
		T[255] = Byte.MAX_VALUE;
	}

	/*
	 * The Pearson hash is computed by repeatedly XOR'ing the bytes of the message
	 */
	public static byte computePearson(byte[] message) {
		byte h=0;
		for (byte b : message) {
			h = T[(h ^ b)-Byte.MIN_VALUE];
			System.out.println(String.format("h = %8s", Integer.toBinaryString(h)).replace(' ', '0'));
		}
		return h;
	}
}
