pragma solidity ^0.5.0;

contract Contract2 {
    
    string[] messages;
    
    event ReceiveMessage (
        address messageSender,
        string message,
        uint256 messageNumber
    );
    
	constructor() public{
	}

	function storeMessage(string memory message) public returns (uint256) {
	    uint256 index = messages.push(message);
	    emit ReceiveMessage (msg.sender, message, index);
	}

	function getMessageAt(uint256 index) public view returns (string memory) {
	    require(index < messages.length, "Index too large");
	    return messages[index];
	}	
	
	function getLength() public view returns (uint256) {
	    return messages.length;
	}
}
