package Default;

import io.reactivex.Flowable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.web3j.abi.EventEncoder;
import org.web3j.abi.TypeReference;
import org.web3j.abi.datatypes.Address;
import org.web3j.abi.datatypes.Event;
import org.web3j.abi.datatypes.Function;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.datatypes.Utf8String;
import org.web3j.abi.datatypes.generated.Uint256;
import org.web3j.crypto.Credentials;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.RemoteCall;
import org.web3j.protocol.core.methods.request.EthFilter;
import org.web3j.protocol.core.methods.response.Log;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.tx.Contract;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.gas.ContractGasProvider;

/**
 * <p>Auto generated code.
 * <p><strong>Do not modify!</strong>
 * <p>Please use the <a href="https://docs.web3j.io/command_line.html">web3j command line tools</a>,
 * or the org.web3j.codegen.SolidityFunctionWrapperGenerator in the 
 * <a href="https://github.com/web3j/web3j/tree/master/codegen">codegen module</a> to update.
 *
 * <p>Generated with web3j version 4.2.0.
 */
public class Contract2 extends Contract {
    private static final String BINARY = "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";

    public static final String FUNC_GETMESSAGEAT = "getMessageAt";

    public static final String FUNC_GETLENGTH = "getLength";

    public static final String FUNC_STOREMESSAGE = "storeMessage";

    public static final Event RECEIVEMESSAGE_EVENT = new Event("ReceiveMessage", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>() {}, new TypeReference<Utf8String>() {}, new TypeReference<Uint256>() {}));
    ;

    @Deprecated
    protected Contract2(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        super(BINARY, contractAddress, web3j, credentials, gasPrice, gasLimit);
    }

    protected Contract2(String contractAddress, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        super(BINARY, contractAddress, web3j, credentials, contractGasProvider);
    }

    @Deprecated
    protected Contract2(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        super(BINARY, contractAddress, web3j, transactionManager, gasPrice, gasLimit);
    }

    protected Contract2(String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        super(BINARY, contractAddress, web3j, transactionManager, contractGasProvider);
    }

    public RemoteCall<String> getMessageAt(BigInteger index) {
        final Function function = new Function(FUNC_GETMESSAGEAT, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.generated.Uint256(index)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Utf8String>() {}));
        return executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteCall<BigInteger> getLength() {
        final Function function = new Function(FUNC_GETLENGTH, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>() {}));
        return executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteCall<TransactionReceipt> storeMessage(String message) {
        final Function function = new Function(
                FUNC_STOREMESSAGE, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Utf8String(message)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public List<ReceiveMessageEventResponse> getReceiveMessageEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = extractEventParametersWithLog(RECEIVEMESSAGE_EVENT, transactionReceipt);
        ArrayList<ReceiveMessageEventResponse> responses = new ArrayList<ReceiveMessageEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            ReceiveMessageEventResponse typedResponse = new ReceiveMessageEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.messageSender = (String) eventValues.getNonIndexedValues().get(0).getValue();
            typedResponse.message = (String) eventValues.getNonIndexedValues().get(1).getValue();
            typedResponse.messageNumber = (BigInteger) eventValues.getNonIndexedValues().get(2).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<ReceiveMessageEventResponse> receiveMessageEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new io.reactivex.functions.Function<Log, ReceiveMessageEventResponse>() {
            @Override
            public ReceiveMessageEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(RECEIVEMESSAGE_EVENT, log);
                ReceiveMessageEventResponse typedResponse = new ReceiveMessageEventResponse();
                typedResponse.log = log;
                typedResponse.messageSender = (String) eventValues.getNonIndexedValues().get(0).getValue();
                typedResponse.message = (String) eventValues.getNonIndexedValues().get(1).getValue();
                typedResponse.messageNumber = (BigInteger) eventValues.getNonIndexedValues().get(2).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<ReceiveMessageEventResponse> receiveMessageEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(RECEIVEMESSAGE_EVENT));
        return receiveMessageEventFlowable(filter);
    }

    @Deprecated
    public static Contract2 load(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        return new Contract2(contractAddress, web3j, credentials, gasPrice, gasLimit);
    }

    @Deprecated
    public static Contract2 load(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        return new Contract2(contractAddress, web3j, transactionManager, gasPrice, gasLimit);
    }

    public static Contract2 load(String contractAddress, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        return new Contract2(contractAddress, web3j, credentials, contractGasProvider);
    }

    public static Contract2 load(String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        return new Contract2(contractAddress, web3j, transactionManager, contractGasProvider);
    }

    public static RemoteCall<Contract2> deploy(Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        return deployRemoteCall(Contract2.class, web3j, credentials, contractGasProvider, BINARY, "");
    }

    public static RemoteCall<Contract2> deploy(Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        return deployRemoteCall(Contract2.class, web3j, transactionManager, contractGasProvider, BINARY, "");
    }

    @Deprecated
    public static RemoteCall<Contract2> deploy(Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        return deployRemoteCall(Contract2.class, web3j, credentials, gasPrice, gasLimit, BINARY, "");
    }

    @Deprecated
    public static RemoteCall<Contract2> deploy(Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        return deployRemoteCall(Contract2.class, web3j, transactionManager, gasPrice, gasLimit, BINARY, "");
    }

    public static class ReceiveMessageEventResponse {
        public Log log;

        public String messageSender;

        public String message;

        public BigInteger messageNumber;
    }
}
