import java.io.ByteArrayOutputStream;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.List;

import org.apache.commons.codec.binary.Hex;

public class Block {

	public List<Transaction> transactions;
	public byte[] merkleTreeRoot;
	public byte[] prevBlockHash;
	public int difficulty;
	public int nonce;
	public byte[] blockHash;
	
	public Block(List<Transaction> transactions, 
					byte[] merkleTreeRoot,
					byte[] prevBlockHash, 
					int nonce,
					int difficulty,
					byte[] hash) {
		this.transactions = List.copyOf(transactions);
		this.merkleTreeRoot = merkleTreeRoot.clone();
		if (prevBlockHash != null) {
			this.prevBlockHash = prevBlockHash.clone();
		} else {
			this.prevBlockHash = null;
		}
		this.nonce = nonce;
		this.difficulty = difficulty;
	}
	
	public boolean Verify() {
		/*
		 * Make sure the message hash is as specified
		 */
		try {
			MessageDigest sha = MessageDigest.getInstance("SHA");
			byte[] h = sha.digest(contentByteArray());
			if (!Arrays.equals(h,  blockHash)) {
				return false;
			}
		} catch (Exception e) {
			return false;
		}
		/*
		 * Verify all transactions first
		 */
		for (Transaction t : transactions) {
			if (!t.Verify()) {
				return false;
			}
		}
		/*
		 * Check the Merkle root
		 */
		if (!Arrays.equals(Miner.MerkleTree(transactions), merkleTreeRoot))
			return false;
		/*
		 * Check the difficulty
		 */
		if (blockHash[0] >>> (8-difficulty) != 0)
			return false;
		/*
		 * If it all works out, return true
		 */
		return true;
	}
	
	public byte[] contentByteArray() {
		try {
			/*
			 * Write all transactions
			 */
			ByteArrayOutputStream stream = new ByteArrayOutputStream();
			for (Transaction t : transactions) {
				stream.write(t.asByteArray());
			}
			/* 
			 * Add the Merkle tree root
			 */
			stream.write(merkleTreeRoot);
			/*
			 * Add the hash of the previous block
			 */
			if (prevBlockHash != null) {
				stream.write(prevBlockHash);
			}
			/*
			 * Add the none and the difficulty
			 */
			stream.write(nonce);
			stream.write(difficulty);
			
			return stream.toByteArray();
		} catch (Exception e) {
			return null;
		}
	}
	
	public String toString() {
		if (prevBlockHash != null) {
		return "Block \n with hash: " + Hex.encodeHexString(blockHash) + 
					"\n with: " + transactions.size() + " transactions," +
					"\n and previous Hash: "+Hex.encodeHexString(prevBlockHash);
		} else {
			return "Block \n with hash: " + Hex.encodeHexString(blockHash) + 
					"\n with: " + transactions.size() + " transactions," +
					"\n and previous Hash: null";
		}
	}
}
