import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

public class Miner {

	public static byte[] MerkleTree(List<Transaction> transactions) {
		try {
			MessageDigest sha = MessageDigest.getInstance("SHA");

			Queue<byte[]> q = new LinkedList<byte[]>();
			for (Transaction t : transactions) {
				q.add(sha.digest(t.asByteArray()));
			}
			if (q.size() == 1) {
				return q.remove();
			}
			while (q.size() > 2) {
				byte[] element1 = q.remove();
				byte[] element2 = q.remove();
	
				ByteArrayOutputStream stream = new ByteArrayOutputStream();
				stream.write(element1);
				stream.write(element2);
				q.add(sha.digest(stream.toByteArray()));
			}
			byte[] element1 = q.remove();
			byte[] element2 = q.remove();
	
			ByteArrayOutputStream stream = new ByteArrayOutputStream();
			stream.write(element1);
			stream.write(element2);
			return sha.digest(stream.toByteArray());
		} catch (NoSuchAlgorithmException e) {
			return null;
		} catch (IOException e) {
			return null;
		}
	}
	
	public static Block mine(List<Transaction> transactions, byte[] prevBlockHash, int difficulty) {
		try {
			MessageDigest sha = MessageDigest.getInstance("SHA");

			byte[] merkleTreeRoot = MerkleTree(transactions);
			int nonce = 0;
	
			Block b;
			byte[] hash;
			do {
				b = new Block(transactions, merkleTreeRoot, prevBlockHash, nonce, difficulty, null);
				hash = sha.digest(b.contentByteArray());
				nonce++;
			} while (hash[0] >>> (8-difficulty) != 0);
			
			System.out.println("Mined a block in " + nonce + " tries");
			
			b.blockHash = hash.clone();
			return b;
		} catch (NoSuchAlgorithmException e) { 
			return null;
		}
	}
	
}
