d <- read.csv('aggregate.prediction.formative.500reps.condition0.grand.means.differences.csv')

d <- d[d$Outer != 'AB',]
d <- d[d$Outer != 'BA',]
d$Outer <- droplevels(d$Outer)

for (z in levels(d$Outer)) {
  print(z)
  print(mean(d[d$Outer==z,]$x.diff))
}
print("Overall:")
print(mean(d$x.diff))

digits.old = getOption("digits")
scipen.old = getOption("scipen")
options(scipen=999)
options(digits=3)

for (z in levels(d$Outer)) {
  print(z)
  print(summary(lm(x.diff~ErrorVar + IndCov + SampleSize + NumInd, data=d[d$Outer==z,]))$coefficients)
}
print("Overall:")
print(summary(lm(x.diff~ErrorVar + IndCov + SampleSize + NumInd, data=d))$coefficients)

options(scipen=scipen.old)
options(digits=digits.old)

