d <- read.csv('aggregate.prediction.formative.500reps.condition0.grand.means.csv')
d <- d[d$Outer != 'AB',]
d <- d[d$Outer != 'BA',]
d$Outer <- droplevels(d$Outer)

for (z in levels(d$Outer)) {
  print(z)
  print(summary(lm(x~SampleSize + NumInd, data=d[d$Outer==z,]))$coefficients)
}
print("Overall:")
print(summary(lm(x~SampleSize + NumInd, data=d))$coefficients)

unique(cbind(d$SampleSize, ave(d$x, d$SampleSize, FUN=mean)))
unique(cbind(d$NumInd, ave(d$x, d$NumInd, FUN=mean)))
unique(cbind(d$ErrorVar, ave(d$x, d$ErrorVar, FUN=mean)))


for (z in levels(d$Outer)) {
  print(z)
  print(summary(lm(x~ErrorVar, data=d[d$Outer==z,]))$coefficients)
}
print("Overall:")
print(summary(lm(x~ErrorVar, data=d))$coefficients)

for (z in levels(d$Outer)) {
  print(z)
  print(summary(lm(x~IndCov, data=d[d$Outer==z,]))$coefficients)
}
print("Overall:")
print(summary(lm(x~IndCov, data=d))$coefficients)

unique(cbind(levels(d$Outer)[d$Outer], ave(d$x, d$Outer, FUN=mean)))
print("Overall:")
print(mean(d$x))


