# Create a fitted object of class 'plspm2'
#
# Input are data, inner model, outer model, and estimation modes
#
plspm2 <- function(data, inner, outer, modes, scheme, predictors, predictands) {
   fit.obj <- list(plspm.fit=plspm(Data=data, path_matrix=inner, blocks=outer, modes=modes, scheme=scheme), predictors=predictors, predictands=predictands)
   class(fit.obj) <- 'plspm2'
   fit.obj
}

#
# Perform prediction from a fitted plspm2 object
#
# Input is the fitted model object and the new independent variable value to predict from
#
# Returns a data frame with predicted values for the dependent variables
#
predict.plspm2 <- function(plspm.fit, X.mat) {

   f <- plspm.fit$plspm.fit
   form.comp <- plspm.fit$predictors
   refl.comp <- plspm.fit$predictands

   comps <- c()
   for (i in form.comp) {
     form.ind.names <- colnames(f$data[ , f$model$blocks[[i]] ])
     comps <- cbind(comps, X.mat[, form.ind.names ] %*% as.matrix(f$outer[f$outer$name %in% form.ind.names, 'weight']))
   }

   model.matrix <- t(f$path_coefs)
   total.effects <- model.matrix
   j <- 2
   repeat {
      m <- model.matrix
      for (i in 2:j) {
        m <- m %*% model.matrix
      }
      total.effects <- total.effects + m
      if (nnzero(m) == 0) {break}
      j <- j + 1
   }

   comps.pred <- comps %*% total.effects[form.comp,-form.comp]

   y.pred <- NULL
   for (i in 1:length(refl.comp)) {
      refl.ind <- refl.comp[i]
      refl.ind.names <- colnames(f$data[ , f$model$blocks[[refl.ind]] ])
      loadings <- as.matrix(f$outer_model[ f$outer_model$name %in% refl.ind.names, 4 ]) 
      y.pred <- cbind(y.pred, as.matrix(comps.pred[ , i]) %*% t(loadings))
   }

   y.pred
}  


