fname.stem <- 'prediction.formative.500reps.condition0'

results.frame <- read.csv(file=paste('aggregate.', fname.stem, '.fold.means.csv', sep=''))

results.frame <- na.omit(results.frame)


a <- aggregate(results.frame[,11], list(Model=results.frame$Model, Condition=results.frame$Condition, SampleSize=results.frame$SampleSize, NumInd=results.frame$NumInd, IndCov=results.frame$IndCov, ErrorVar=results.frame$ErrorVar, PEstimator=results.frame$PEstimator, Inner=results.frame$Inner, Outer=results.frame$Outer), sd)

b <- aggregate(a[,10], list(Condition=a$Condition, SampleSize=a$SampleSize, NumInd=a$NumInd, IndCov=a$IndCov, ErrorVar=a$ErrorVar, PEstimator=a$PEstimator, Inner=a$Inner, Outer=a$Outer), mean)

b <- b[b$Outer != 'AB',]
b <- b[b$Outer != 'BA',]

b$ErrorVar <- as.factor(b$ErrorVar)
b$IndCov <- as.factor(b$IndCov)
b$NumInd <- as.factor(b$NumInd)
b$SampleSize <- as.factor(b$SampleSize)

library(tables)

t <- tabular(b$SampleSize * b$NumInd * b$ErrorVar ~ b$Outer * b$IndCov * (b$x * mean) * Format(digits=2))
t <- t[, -c(4:6, 10:12)]

write.csv.tabular(t, file=paste("Table.", fname.stem, ".RMSE.sd.csv", sep=''))

