fname.stem <- 'prediction.formative.500reps.condition1'

#    results.frame <- read.csv(file=paste(fname.stem, '.results.csv', sep=''))

#	results.frame <- na.omit(results.frame)

#    	a <- aggregate(results.frame[,12], list(Repetition=results.frame$Repetition, Model=results.frame$Model, Condition=results.frame$Condition, SampleSize=results.frame$SampleSize, NumInd=results.frame$NumInd, IndCov=results.frame$IndCov, ErrorVar=results.frame$ErrorVar, PEstimator=results.frame$parameterEstimator, Inner=results.frame$innerEstimator, Outer=results.frame$outerEstimator), mean)

#        write.csv(a, file=paste('aggregate.', fname.stem, '.fold.means.csv', sep=''), row.names=F)

#	results.frame <- a

#    	a <- aggregate(results.frame[,11], list(Model=results.frame$Model, Condition=results.frame$Condition, SampleSize=results.frame$SampleSize, NumInd=results.frame$NumInd, IndCov=results.frame$IndCov, ErrorVar=results.frame$ErrorVar, PEstimator=results.frame$PEstimator, Inner=results.frame$Inner, Outer=results.frame$Outer), length)
#        write.csv(a, file=paste('aggregate.', fname.stem, '.count.csv', sep=''), row.names=F)

#   	a <- aggregate(results.frame[,11], list(Model=results.frame$Model, Condition=results.frame$Condition, SampleSize=results.frame$SampleSize, NumInd=results.frame$NumInd, IndCov=results.frame$IndCov, ErrorVar=results.frame$ErrorVar, PEstimator=results.frame$PEstimator, Inner=results.frame$Inner, Outer=results.frame$Outer), var)
#        write.csv(a, file=paste('aggregate.', fname.stem, '.variances.csv', sep=''), row.names=F)

#    	a <- aggregate(results.frame[,11], list(Model=results.frame$Model, Condition=results.frame$Condition, SampleSize=results.frame$SampleSize, NumInd=results.frame$NumInd, IndCov=results.frame$IndCov, ErrorVar=results.frame$ErrorVar, PEstimator=results.frame$PEstimator, Inner=results.frame$Inner, Outer=results.frame$Outer), sd)
#        write.csv(a, file=paste('aggregate.', fname.stem, '.sd.csv', sep=''), row.names=F)

#    	a <- aggregate(results.frame[,11], list(Model=results.frame$Model, Condition=results.frame$Condition, SampleSize=results.frame$SampleSize, NumInd=results.frame$NumInd, IndCov=results.frame$IndCov, ErrorVar=results.frame$ErrorVar, PEstimator=results.frame$PEstimator, Inner=results.frame$Inner, Outer=results.frame$Outer), mean)
#        write.csv(a, file=paste('aggregate.', fname.stem, '.grand.means.csv', sep=''), row.names=F)

	a <- read.csv(file=paste('aggregate.', fname.stem, '.fold.means.csv', sep=''))
	t.test.results <- NULL
	# pairwise t.tests
	for (model in levels(as.factor(a$Model))) {
		for (condition in levels(as.factor(a$Condition))) {
			for (samplesize in levels(as.factor(a$SampleSize))) {
				for (numind in levels(as.factor(a$NumInd))) {
					for (errorvar in levels(as.factor(a$ErrorVar))) {
						for (indcov in levels(as.factor(a$IndCov))) {
							a.sub <- a[a$Model == model & a$Condition == condition & a$SampleSize == samplesize & a$NumInd == numind & a$ErrorVar == errorvar & a$IndCov == indcov,]
							s <- data.frame(cbind(	a.sub[a.sub$Outer == 'ML',]$x,
												a.sub[a.sub$Outer == 'A',]$x	))
							colnames(s) <- c('ML', 'PLS.A')

							s <- s[, order(-colMeans(s))]

							for (c in 2:ncol(s) ) {
								test.result <- t.test(s[,c-1], s[,c], paired=TRUE)
								t.test.results <- rbind(t.test.results, cbind(model, condition, samplesize, numind, errorvar, indcov, colnames(s)[c-1], colnames(s)[c], test.result$p.value, test.result$parameter, test.result$statistic, test.result$estimate))	
							}

							d <- list()
							for ( e in 1:ncol(s)) {
								d[[e]] <- density(s[, e])
							}
							max.x = max(unlist(lapply(d, function(X) { max(X$x) } )))
							max.y = max(unlist(lapply(d, function(X) { max(X$y) } )))
							min.x = min(unlist(lapply(d, function(X) { min(X$x) } )))
							min.y = 0

							jpeg(filename=paste("RMSE.density.model", model, ".n", samplesize, ".i", numind, ".e", errorvar, ".c", indcov, '.jpeg', sep=''), width=1000, height=1000, res=150)
							colors = c("black", "blue", "green", "red", "yellow", "magenta")
							plot(density(s[, 1]), lwd=2, xlim=c(min.x, max.x), ylim=c(min.y, max.y), col=colors[1], main=paste("RMSE density for model ", model, ", n=", samplesize, ", i=", numind, ", e=", errorvar, ", c=", indcov, sep=''), sub='', ylab='')
								
							for (e in 2:ncol(s)) {
								lines(density(s[, e]), lwd=2, col=colors[e])
							}
							legend(x="topright", legend=colnames(s), fill=colors, col=colors, border="black")
							dev.off()
						}
					}
				}
			}
		}
	}

	colnames(t.test.results) <- c('Model', 'Condition', 'SampleSize', 'NumInd', 'ErrorVar', 'IndCov', 'M1', 'M2', 'P.Value', 'DF', 'T', 'MeanDiff')

	write.csv(t.test.results, file=paste(fname.stem, '.t.test.results.csv', sep=''), row.names=F)
	t.test.results <- read.csv(file=paste(fname.stem, '.t.test.results.csv', sep=''))
	write.csv(format(t.test.results, scientific=FALSE, digits=5), file=paste(fname.stem, '.t.test.results.csv', sep=''), row.names=F)


d <- read.csv(paste('aggregate.', fname.stem, '.grand.means.csv', sep=''))
d$ErrorVar <- as.factor(d$ErrorVar)
d$IndCov <- as.factor(d$IndCov)
d$NumInd <- as.factor(d$NumInd)
d$SampleSize <- as.factor(d$SampleSize)
d$Model <- as.factor(d$Model)

library(tables)

for (model in levels(d$Model)) {
	 d.sub = d[d$Model==model,]
	 t <- tabular(SampleSize * NumInd * ErrorVar ~ Outer * IndCov * (x * mean) * Format(digits=3), data=d.sub)
	 write.csv.tabular(t, file=paste("Table.Model", model, ".", fname.stem, ".grand.means.csv", sep=''))

}

