# #### PLS PM fit #### #

fit.pls.a <- function(model, mode, scheme, n.ind, data) {

   if (model ==3) {
     # correct model
	model3.inner <- matrix(c( 0, 0, 0, 0, 0, 0, 0, 0,
		                     0, 0, 0, 0, 0, 0, 0, 0,
		                     0, 0, 0, 0, 0, 0, 0, 0,
		                     1, 1, 0, 0, 0, 0, 0, 0,
		                     0, 1, 1, 0, 0, 0, 0, 0,
		                     0, 0, 0, 1, 0, 0, 0, 0,
		                     0, 0, 0, 1, 1, 0, 0, 0,
		                     0, 0, 0, 0, 1, 0, 0, 0 ), nrow=8, byrow=T)

	if (mode == 'A' | mode == 'B')
		model3.modes <- rep(mode, 8)
	if (mode == 'AB')
		model3.modes <- c( rep('B', 3), rep('A', 5) )

	if (n.ind == 3)
           model3.outer.ind <- list(c(1:3), c(4:6), c(7:9), c(10:12), c(13:15), c(16:18), c(19:21), c(22:24))
	if (n.ind == 5)
           model3.outer.ind <- list(c(1:5), c(6:10), c(11:15), c(16:20), c(21:25), c(26:30), c(31:35), c(36:40))
	if (n.ind == 7)
           model3.outer.ind <- list(c(1:7), c(8:14), c(15:21), c(22:28), c(29:35), c(36:42), c(43:49), c(50:56))

	plspm.fitted <- plspm2(data, model3.inner, model3.outer.ind, model3.modes, scheme, 1:3, 4:8)
   }

   plspm.fitted
}

fit.pls.b <- function(model, mode, scheme, n.ind, data) {

   if (model ==3) {
     # misspecified condition 2
	model3.inner <- matrix(c( 0, 0, 0, 0, 0, 0, 0, 0,
		                     0, 0, 0, 0, 0, 0, 0, 0,
		                     0, 0, 0, 0, 0, 0, 0, 0,
		                     1, 1, 0, 0, 0, 0, 0, 0,
		                     0, 1, 1, 0, 0, 0, 0, 0,
		                     1, 0, 0, 1, 0, 0, 0, 0,
		                     0, 1, 0, 1, 1, 0, 0, 0,
		                     0, 0, 1, 0, 1, 0, 0, 0 ), nrow=8, byrow=T)

	if (mode == 'A' | mode == 'B')
		model3.modes <- rep(mode, 8)
	if (mode == 'AB')
		model3.modes <- c( rep('B', 3), rep('A', 5) )

	if (n.ind == 3)
           model3.outer.ind <- list(c(1:3), c(4:6), c(7:9), c(10:12), c(13:15), c(16:18), c(19:21), c(22:24))
	if (n.ind == 5)
           model3.outer.ind <- list(c(1:5), c(6:10), c(11:15), c(16:20), c(21:25), c(26:30), c(31:35), c(36:40))
	if (n.ind == 7)
           model3.outer.ind <- list(c(1:7), c(8:14), c(15:21), c(22:28), c(29:35), c(36:42), c(43:49), c(50:56))

	plspm.fitted <- plspm2(data, model3.inner, model3.outer.ind, model3.modes, scheme, 1:3, 4:8)
   }

   plspm.fitted
}

