# Create a fitted object of class 'lavaan2'
#
# Input are data, inner model, outer model, and estimation modes
#
lavaan2 <- function(model,data) {
   fit.obj <- sem(model=model, data=data, fixed.x=TRUE)
   class(fit.obj) <- 'lavaan2'
   fit.obj
}

#
# A prediction function for lavaan objects
#
# Input is a fitted lavaan object and the matrix of independent variable values
#
# Returns a dataframe with predicted values for the dependent variables
#
predict.lavaan2 <- function(fit.model, X.mat) {

 class(fit.model) <- 'lavaan'

  sem.coefs <- inspect(fit.model, "coef")

  man.names <- fit.model@Data@ov.names[[1]]
  lat.names <- setdiff(colnames(sem.coefs$beta), man.names)
  beta.latents <- sem.coefs$beta[lat.names, lat.names]
# names of exogenous latents
  form.exog <- names(which(apply(beta.latents, 1, sum) == 0))
# names of formative latents
  form.lat <- names(which(apply(sem.coefs$beta[lat.names,intersect(colnames(sem.coefs$beta),man.names)], 1, sum) > 0))
# names of reflective latents
  refl.lat <- setdiff(lat.names, form.lat)
# Continue only if all formative variables are also exogenous, and all exogenous variables are also formative
  if (!(length(form.lat) == length(form.exog) && length(intersect(form.lat, form.exog))==length(form.lat))) {
    stop("lavaan.predict requires all formative latents to be exogenous and all exogenous latents to be formative!")
  }

# names of formative indicators
  form.ind <- names(which(apply(sem.coefs$theta, 1, sum) == 0))
  
  exog.latents <- as.matrix(X.mat) %*% t(matrix(sem.coefs$beta[form.lat,form.ind], nrow=length(form.lat), ncol=length(form.ind)))
  colnames(exog.latents) <- form.lat
  model.matrix <- t(beta.latents)
  total.effects <- model.matrix
  k <- 2
  repeat {
    m <- model.matrix
    for (i in 2:k) {
      m <- m %*% model.matrix
    }
    total.effects <- total.effects + m
    if (nnzero(m) == 0) {break}
    k <- k + 1
  }

  endog.latents <- exog.latents %*% total.effects[form.exog,setdiff(colnames(total.effects),form.exog)]

  y.pred <- endog.latents %*% t(as.matrix(sem.coefs$lambda[setdiff(rownames(sem.coefs$lambda),form.ind), refl.lat]))
  y.scales <- y.pred %*% diag(1/sqrt(diag(cov(y.pred))), nrow=ncol(y.pred), ncol=ncol(y.pred))

  y.scales
}

