
imp.blindfold <- function(lavaan.model, data, con, k=5) {
  diff_e <- 0
  diff_o <- 0

  user <- lavaanify(lavaan.model)
  user <- user[user$op=='=~' & user$lhs %in% con,]
  cols.predictands <- as.vector(user$rhs)

  for (i in 1:k) {
	miss <- rep(0, k)
	miss[i] <- NA
	missing.matrix <- matrix(0, nrow=nrow(data), ncol=ncol(data), byrow=F)
	colnames(missing.matrix) <- colnames(data)

# this is the correct version
	if (length(missing.matrix[, cols.predictands]) %% k > 0) {
		missing.matrix[,cols.predictands] <- matrix(c(rep(miss, length(missing.matrix[, cols.predictands]) %/% k), miss[1:(length(missing.matrix[, cols.predictands]) %% k)]), ncol=length(cols.predictands), nrow=nrow(data), byrow=TRUE)
	} else {
		missing.matrix[,cols.predictands] <- matrix(rep(miss, length(missing.matrix[, cols.predictands]) %/% k), ncol=length(cols.predictands), nrow=nrow(data), byrow=TRUE) }

	missing.data <- data + missing.matrix
	missingness <- is.na(missing.data)

	mean.data <- NULL
	for (c in 1:ncol(missing.data)) {
		mean.data <- cbind(mean.data, replace(missing.data[,c], is.na(missing.data[,c]), mean(missing.data[,c], na.rm=T))) }
	colnames(mean.data) <- colnames(data)

	s <- prelim.norm(data)
	t <- em.norm(s, showits=FALSE, maxits=2000, criterion=0.001)
	predict <- imp.norm(s, t, missing.data)
	rngseed(123456789)
	for (j in 1:19) {
		predict <- predict + imp.norm(s, t, missing.data)
	}
	predict <- predict / 20

	diff_e <- diff_e + sum( (stack(as.data.frame(data))[,1][stack(as.data.frame(missingness))[,1]] - stack(as.data.frame(predict))[,1][stack(as.data.frame(missingness))[,1]])^2 )
	diff_o <- diff_o + sum( (stack(as.data.frame(data))[,1][stack(as.data.frame(missingness))[,1]] - stack(as.data.frame(mean.data))[,1][stack(as.data.frame(missingness))[,1]])^2 )
  }
  return( 1 - (diff_e / diff_o) )
}


