
lavaan.blindfold <- function(lavaan.model, data, predicted.names, k=5) {
  diff_e.com <- 0
  diff_e.red <- 0
  diff_o <- 0

  user <- lavaanify(lavaan.model)
  user <- user[user$op=='=~' & user$lhs %in% predicted.names,]
  cols.predictands <- as.vector(user$rhs)
 
  for (i in 1:k) {
	miss <- rep(0, k)
	miss[i] <- NA
	missing.matrix <- matrix(0, nrow=nrow(data), ncol=ncol(data), byrow=F)
    colnames(missing.matrix) <- colnames(data)

# this is the correct version
	if (length(missing.matrix[, cols.predictands]) %% k > 0) {
		missing.matrix[,cols.predictands] <- matrix(c(rep(miss, length(missing.matrix[, cols.predictands]) %/% k), miss[1:(length(missing.matrix[, cols.predictands]) %% k)]), ncol=length(cols.predictands), nrow=nrow(data), byrow=TRUE)
	} else {
		missing.matrix[,cols.predictands] <- matrix(rep(miss, length(missing.matrix[, cols.predictands]) %/% k), ncol=length(cols.predictands), nrow=nrow(data), byrow=TRUE) }

	missing.data <- data + missing.matrix
	missingness <- is.na(missing.data)

	mean.data <- NULL
	for (c in 1:ncol(missing.data)) {
		mean.data <- cbind(mean.data, replace(missing.data[,c], is.na(missing.data[,c]), mean(missing.data[,c], na.rm=T))) }
	colnames(mean.data) <- colnames(data)

	lavaan.result <- sem(lavaan.model, data=data)

	pred.com <- predict(lavaan.result)

    beta.latents <- inspect(lavaan.result, "coef")$beta
	model.matrix <- t(beta.latents)
    total.effects <- model.matrix
    j <- 2
    repeat {
      m <- model.matrix
      for (i in 2:j) {
        m <- m %*% model.matrix
      }
      total.effects <- total.effects + m
      if (nnzero(m) == 0) {break}
      j <- j + 1
    }
	
    predictor.names <- setdiff(colnames(beta.latents), predicted.names)
    predictor.latents <- pred.com[,predictor.names]
	if (length(predictor.names) < 2) {
      # This is necessary because a matrix of 1 column degenerates and must be made into a matrix using as.matrix
      # Furthermore, despite telling R that this is a 1xk matrix, it becomes a kx1 matrix and thus must be transposed	  
      predicted.latents <- as.matrix(predictor.latents, ncol=1, nrow=nrow(data)) %*% 
							t(as.matrix(total.effects[predictor.names,predicted.names], ncol=1, nrow=length(predicted.names)))
    } else {
      predicted.latents <- predictor.latents %*% total.effects[predictor.names,predicted.names]
	}
	pred.red <- cbind(predictor.latents, predicted.latents)

	predict.com <- pred.com %*% t(lavaan.result@Model@GLIST$lambda)
	predict.red <- pred.red %*% t(lavaan.result@Model@GLIST$lambda)

	colnames(predict.com) <- colnames(data)
	colnames(predict.red) <- colnames(data)

	diff_e.com <- diff_e.com + sum( (stack(as.data.frame(data))[,1][stack(as.data.frame(missingness))[,1]] - stack(as.data.frame(predict.com))[,1][stack(as.data.frame(missingness))[,1]])^2 )
	diff_e.red <- diff_e.red + sum( (stack(as.data.frame(data))[,1][stack(as.data.frame(missingness))[,1]] - stack(as.data.frame(predict.red))[,1][stack(as.data.frame(missingness))[,1]])^2 )
	diff_o <- diff_o + sum( (stack(as.data.frame(data))[,1][stack(as.data.frame(missingness))[,1]] - stack(as.data.frame(mean.data))[,1][stack(as.data.frame(missingness))[,1]])^2 )
  }
  return( c( 1 - (diff_e.com / diff_o), 1 - (diff_e.red / diff_o) ) )
}


