     fname.stem <- 'prediction.reflective.condition0'

	results.frame <- read.csv(file=paste(fname.stem, '.csv', sep=''))
	results.frame <- na.omit(results.frame)

	levels(results.frame$pred.method)[levels(results.frame$pred.method)=="comp"] <- 'comm'

	results.frame$Replication<-ave(results.frame$Q2, results.frame$Model, results.frame$Condition, results.frame$SampleSize, results.frame$NumInd, results.frame$ErrorVar, results.frame$loadings, results.frame$beta, results.frame$PEstimator, results.frame$Outer, results.frame$Inner, results.frame$pred.method, FUN=seq_along)

	results.frame <- results.frame[results.frame$Replication <= 300,]

    	a <- aggregate(results.frame[,13], list(Model=results.frame$Model, Condition=results.frame$Condition, SampleSize=results.frame$SampleSize, NumInd=results.frame$NumInd, ErrorVar=results.frame$ErrorVar, loadings=results.frame$loadings, beta=results.frame$beta, PEstimator=results.frame$PEstimator, Inner=results.frame$Inner, Outer=results.frame$Outer, pred.method=results.frame$pred.method), mean)
     write.csv(a, file=paste('aggregate.', fname.stem, '.means.csv', sep=''), row.names=F)

    	a <- aggregate(results.frame[,13], list(Model=results.frame$Model, Condition=results.frame$Condition, SampleSize=results.frame$SampleSize, NumInd=results.frame$NumInd, ErrorVar=results.frame$ErrorVar, loadings=results.frame$loadings, beta=results.frame$beta, PEstimator=results.frame$PEstimator, Inner=results.frame$Inner, Outer=results.frame$Outer, pred.method=results.frame$pred.method), var)
     write.csv(a, file=paste('aggregate.', fname.stem, '.variances.csv', sep=''), row.names=F)

    	a <- aggregate(results.frame[,13], list(Model=results.frame$Model, Condition=results.frame$Condition, SampleSize=results.frame$SampleSize, NumInd=results.frame$NumInd, ErrorVar=results.frame$ErrorVar, loadings=results.frame$loadings, beta=results.frame$beta, PEstimator=results.frame$PEstimator, Inner=results.frame$Inner, Outer=results.frame$Outer, pred.method=results.frame$pred.method), length)
     write.csv(a, file=paste('aggregate.', fname.stem, '.count.csv', sep=''), row.names=F)

    	a <- aggregate(results.frame[,13], list(Model=results.frame$Model, Condition=results.frame$Condition, SampleSize=results.frame$SampleSize, NumInd=results.frame$NumInd, ErrorVar=results.frame$ErrorVar, loadings=results.frame$loadings, beta=results.frame$beta, PEstimator=results.frame$PEstimator, Inner=results.frame$Inner, Outer=results.frame$Outer, pred.method=results.frame$pred.method), sd)
     write.csv(a, file=paste('aggregate.', fname.stem, '.sd.csv', sep=''), row.names=F)

    	b <- aggregate(a[,12], list(Condition=a$Condition, SampleSize=a$SampleSize, NumInd=a$NumInd, ErrorVar=a$ErrorVar, loadings=a$loadings, beta=a$beta, PEstimator=a$PEstimator, Inner=a$Inner, Outer=a$Outer), mean)
     write.csv(b, file=paste('aggregate.', fname.stem, '.sd.no_mode.no_predmethod.csv', sep=''), row.names=F)

	a <- results.frame
	t.test.results <- NULL

	# pairwise t.tests
	for (model in levels(as.factor(a$Model))) {
		for (condition in levels(as.factor(a$Condition))) {
			for (samplesize in levels(as.factor(a$SampleSize))) {
				for (numind in c(3,5,7)) {
					for (errorvar in levels(as.factor(a$ErrorVar))) {
						for (loading in levels(as.factor(a$loadings))) {

							a.sub <- a[a$Model == model & a$Condition == condition & a$SampleSize == samplesize & a$NumInd == numind & a$ErrorVar == errorvar & a$loadings == loading,]

							s <- data.frame(cbind(	a.sub[a.sub$Outer == 'ML' & a.sub$pred.method == 'comm',]$Q2,
												a.sub[a.sub$Outer == 'ML' & a.sub$pred.method == 'red',]$Q2,
												a.sub[a.sub$Outer == 'outer.modeA' & a.sub$PEstimator == 'params.plsc' & a.sub$pred.method == 'comm',]$Q2,
												a.sub[a.sub$Outer == 'outer.modeA' & a.sub$PEstimator == 'params.plsc' & a.sub$pred.method == 'red',]$Q2,
												a.sub[a.sub$Outer == 'outer.modeA' & a.sub$PEstimator == 'params.regression' & a.sub$pred.method == 'comm',]$Q2,
												a.sub[a.sub$Outer == 'outer.modeA' & a.sub$PEstimator == 'params.regression' & a.sub$pred.method == 'red',]$Q2,

							colnames(s) <- c('ML.comm', 'ML.red', 'PLSC.A.comm', 'PLSC.A.red', 'PLSPM.A.comm', 'PLSPM.A.red')

							s <- s[, order(-colMeans(s))]

							for (c in 2:ncol(s) ) {
								test.result <- t.test(s[,c-1], s[,c], paired=TRUE)
								t.test.results <- rbind(t.test.results, cbind(model, condition, samplesize, numind, errorvar, loading, colnames(s)[c-1], colnames(s)[c], test.result$p.value, test.result$parameter, test.result$statistic, test.result$estimate))	
							}

							d <- list()
							for ( e in 1:ncol(s)) {
								d[[e]] <- density(s[, e])
							}

							min.x = min(unlist(lapply(d, function(X) { min(X$x) } )))
							max.x = max(unlist(lapply(d, function(X) { max(X$x) } )))
							min.y = 0
							max.y = max(unlist(lapply(d, function(X) { max(X$y) } )))

							jpeg(filename=paste("Q2.density.model", model, ".condition", condition, ".n", samplesize, ".i", numind, ".e", errorvar, ".l", loading, ".jpeg", sep=''), width=1000, height=1000, res=150)
							par(mar=c(5.1, 4.1, 4.1, 11.1), xpd=TRUE)
							colors = c("black", "blue", "green", "red", "yellow", "purple", "cyan", "tan", "pink", "orange", "magenta")
							plot(d[[1]], lwd=2, xlim=c(min.x, max.x), ylim=c(min.y, max.y), col=colors[1], main=paste("Q2 density for model ", model, ", n=", samplesize, ", i=", numind, ", e=", errorvar, "l=", loading, sep=''), sub='', ylab='')
							
							for (e in 2:ncol(s)) {
								lines(d[[e]], lwd=2, col=colors[e])
							}
							legend(x="topright", legend=colnames(s), fill=colors, col=colors, border="black", inset=c(-0.5,0) )
							par(xpd=FALSE)
							dev.off()
						}
					}
				}
			}
		}
	}

	colnames(t.test.results) <- c('Model', 'Condition', 'SampleSize', 'NumInd', 'ErrorVar', 'Loading', 'A', 'B', 'P.Value', 'DF', 'T', 'MeanDiff')

	write.csv(t.test.results, file=paste(fname.stem, '.t.test.results.csv', sep=''), row.names=F)
	t.test.results <- read.csv(file=paste(fname.stem, '.t.test.results.csv', sep=''))
	write.csv(format(t.test.results, scientific=FALSE, digits=5), file=paste(fname.stem, '.t.test.results.csv', sep=''), row.names=F)

