
matrixpls.blindfold <- function(lavaan.model, data, predictands, k, outerEstimators, innerEstimator, parameterEstimator) {
  diff_e.com <- 0
  diff_e.red <- 0
  diff_o <- 0

  user <- lavaanify(lavaan.model)
  user <- user[user$op=='=~' & user$lhs %in% predictands,]
  cols.predictands <- as.vector(user$rhs)

  for (i in 1:k) {
	miss <- rep(0, k)
	miss[i] <- NA
	missing.matrix <- matrix(0, nrow=nrow(data), ncol=ncol(data), byrow=F)
    colnames(missing.matrix) <- colnames(data)
	
# this is the correct version
	if (length(missing.matrix[, cols.predictands]) %% k > 0) {
		missing.matrix[,cols.predictands] <- matrix(c(rep(miss, length(missing.matrix[, cols.predictands]) %/% k), miss[1:(length(missing.matrix[, cols.predictands]) %% k)]), ncol=length(cols.predictands), nrow=nrow(data), byrow=TRUE)
	} else {
		missing.matrix[,cols.predictands] <- matrix(rep(miss, length(missing.matrix[, cols.predictands]) %/% k), ncol=length(cols.predictands), nrow=nrow(data), byrow=TRUE) }

	missing.data <- data + missing.matrix
	missingness <- is.na(missing.data)

	mean.data <- NULL
	for (c in 1:ncol(missing.data)) {
		mean.data <- cbind(mean.data, replace(missing.data[,c], is.na(missing.data[,c]), mean(missing.data[,c], na.rm=T))) }
	colnames(mean.data) <- colnames(data)

	plsc.result <- matrixpls(cov(mean.data), lavaan.model, outerEstimators=outerEstimators, innerEstimator=innerEstimator, parameterEstimator=parameterEstimator)

    W <- attr(plsc.result, 'W')
    scores <- mean.data %*% t(W)
    scores.predictands <- scores %*% t(effects(plsc.result)$Total) 
    l <- loadings(plsc.result)

	predict.com <- scores %*% t(l)
    predict.red <- scores.predictands %*% t(l[, predictands])

	colnames(predict.com) <- colnames(data)
	colnames(predict.red) <- colnames(data)

	diff_e.com <- diff_e.com + sum( (stack(as.data.frame(data))[,1][stack(as.data.frame(missingness))[,1]] - stack(as.data.frame(predict.com))[,1][stack(as.data.frame(missingness))[,1]])^2 )
	diff_e.red <- diff_e.red + sum( (stack(as.data.frame(data))[,1][stack(as.data.frame(missingness))[,1]] - stack(as.data.frame(predict.red))[,1][stack(as.data.frame(missingness))[,1]])^2 )
	diff_o <- diff_o + sum( (stack(as.data.frame(data))[,1][stack(as.data.frame(missingness))[,1]] - stack(as.data.frame(mean.data))[,1][stack(as.data.frame(missingness))[,1]])^2 )
  }
  return( c( 1 - (diff_e.com / diff_o), 1 - (diff_e.red / diff_o) ) )
}


