library(MASS)
library(Matrix)
library(lavaan)
library(plspm)
library(matrixpls)
library(norm)
library(numbers)
library(doParallel)
library(foreach)

source('setup.models.condition2.R')
source('lavaan.blindfold.R')
source('imp.blindfold.R')
source('matrixpls.blindfold.R')

generate.ram.model <- function(
	num.exo, 
	num.endo, 
	i, 
	e=0.1, 
	l=1, 
	b=0.75,
	beta=matrix(0, nrow=num.endo, ncol=num.endo), 
	gamma=matrix(1, nrow=num.exo, ncol=num.endo)
) {

  model <- NULL

# n=number of samples
# i=number of indicators
# e=error variance
# l=loading
# b=structural coefficient

  num.latent <- num.exo + num.endo 
  num.obs <- num.latent * i
  num.var <- num.obs + num.latent

  beta <- b * beta
  gamma <- b * gamma

# set up the RAM model matrices

  A <- matrix(0, nrow=num.var, ncol=num.var)
  I <- diag(1, nrow=num.var, ncol=num.var)
  S <- diag(e, nrow=num.var, ncol=num.var)
  S[ (num.obs+1):(num.obs+num.exo), (num.obs+1):(num.obs+num.exo)] <- diag(1, nrow=num.exo, ncol=num.exo)

  for (j in 1:(i*num.latent)) {
    A[j, num.obs + ceiling(j / i)] <- l
  }

  A[(num.obs+num.exo+1):(num.var), (num.obs+num.exo+1):(num.var)] <- beta
  A[(num.obs+num.exo+1):(num.var), (num.obs+1):(num.obs+num.exo)] <- gamma

  model$A <- A
  model$S <- S
  model$I <- I
  model$i <- i
  model$num.exo <- num.exo
  model$num.endo <- num.endo
  model$num.obs <- num.obs
  model$num.var <- num.var
  model$num.latent <- num.latent

  model
}


generate.ram.covariance <- function( ram ) {
  c <- solve(ram$I - ram$A) %*% ram$S %*% t(solve(ram$I - ram$A))
  c <- c[1:ram$num.obs, 1:ram$num.obs]

  rownames(c) <- rep('x', nrow(c))
  for (count in 1:(ram$i*ram$num.exo)) {
    rownames(c)[count] <- paste('x', count, sep="")
  }
  for (count in 1:(ram$i*ram$num.endo)) {
    rownames(c)[(ram$i*ram$num.exo)+count] <- paste('y', count, sep="")
  }
  colnames(c) <- rownames(c)
  c
}


generate.sample <- function(n, cov) {
  data <- mvrnorm(n=n, mu=rep(0, nrow(cov)), Sigma=cov)
  data
}

run.model <- function(model, i=3, e=0.1, l=0.75, b=0.25, n=250, num.samples=1, fname.stem) {

 if (model=="M3") {
   num.exo <- 3
   num.endo <- 5
   beta <- matrix(c(0, 0, 1, 1, 0,  0, 0, 0, 1, 1,  0, 0, 0, 0, 0,  0, 0, 0, 0, 0,  0, 0, 0, 0, 0), nrow=num.endo, ncol=num.endo)
   gamma <- t(matrix(c(1, 0, 0, 0, 0,  1, 1, 0, 0, 0,  0, 1, 0, 0, 0), nrow=num.exo, ncol=num.endo, byrow=T))
   names <- c('a', 'b', 'c', 'k', 'l', 'x', 'y', 'z')
   blind.con <- c('k', 'l', 'x', 'y', 'z')
   lavaan.model <- build.model3.lavaan(i)
 }

 num.latent <- num.exo + num.endo
 num.obs <- num.latent * i
 ram.model <- generate.ram.model( num.exo, num.endo, i, e, l, b, beta, gamma )

 existing <- read.csv(paste('aggregate.', fname.stem, '.count.csv', sep=''))
 samples.todo <- (num.samples - min(existing$x)) * 10

#   r <- NULL
   results <- foreach (scount=1:samples.todo,.combine=rbind, 
                    	.export=c('generate.ram.model', 'generate.ram.covariance', 'generate.sample', 'matrixpls.blindfold', 'lavaan.blindfold', 'imp.blindfold'), 
					.packages=c('matrixpls', 'lavaan', 'norm', 'MASS', 'Matrix', 'numbers')) %dopar% {
#   for (scount in 1:num.samples) {
       print(paste("Sample", scount))
	  flush.console()

       ram.cov <- generate.ram.covariance(ram.model)	  
       data <- generate.sample(n, ram.cov)
	  
	  omission.dist <- nextPrime(i)
	  if ( (length(blind.con) * i) %% omission.dist == 0) {
		omission.dist <- omission.dist + 1
	  }
       r <- NULL

       for (parameterEstimator in c('params.plsc', 'params.regression') ) {
         for (outerEstimator in c('outer.modeA') ) {
# We don't estimate mode B for the misspecification condition because of its poor performance.
           for (innerEstimator in c('inner.centroid') ) {
# inner estimator does not matter at all, no point in simulating them
# (no differences in the 6th decimal place)

             exist.num = min(existing[existing$Model==model & existing$NumInd==i & existing$SampleSize==n & existing$loadings==l & existing$beta==b & existing$ErrorVar==e & existing$PEstimator==parameterEstimator & existing$Outer==outerEstimator & existing$Inner==innerEstimator,'x']) + scount-1
		   if (exist.num < num.samples) {
		      print(paste("PLS samples remaining: ", num.samples - exist.num, sep=''))

			 repcount = 0
                repeat {
                  bfold <- matrixpls.blindfold(lavaan.model, data, blind.con, omission.dist, outerEstimators=get(outerEstimator), innerEstimator=get(innerEstimator), parameterEstimator=get(parameterEstimator))
                  bfold <- replace(bfold, bfold < -1, NA)
                  if ( (!is.na(bfold[1]) & !is.na(bfold[2])) | repcount > 5 ) break
                  print("Repeating PLS")
                  flush.console()
                  repcount <- repcount+1
               }
               r <- rbind(r, c(model, 0, n, i, e, l, b, scount, parameterEstimator, outerEstimator, innerEstimator, 'comm', bfold[1]))
               r <- rbind(r, c(model, 0, n, i, e, l, b, scount, parameterEstimator, outerEstimator, innerEstimator, 'red', bfold[2]))
             }
           }
         }
       }

       exist.num = min(existing[existing$Model==model & existing$NumInd==i & existing$SampleSize==n & existing$loadings==l & existing$beta==b & existing$ErrorVar==e & existing$PEstimator=='ML' & existing$Outer=='ML' & existing$Inner=='ML','x'])  + scount-1
       if (exist.num < num.samples) {
         print(paste("ML samples remaining: ", num.samples - exist.num, sep=''))
         repcount = 0
 	    repeat {
	 	  bfold <- lavaan.blindfold(lavaan.model, data, blind.con, omission.dist)
	       if (!is.nan(bfold)) { 
              bfold <- replace(bfold, bfold < -1, NA)
              if(!is.na(bfold) | repcount>5) break
		  }
		  print("Repeating ML")
		  flush.console()
		  repcount <- repcount+1
	    }
         r <- rbind(r, c(model, 0, n, i, e, l, b, scount, 'ML', 'ML', 'ML', 'comm', bfold[1]))
         r <- rbind(r, c(model, 0, n, i, e, l, b, scount, 'ML', 'ML', 'ML', 'red', bfold[2]))
	  }

       r
  }
#  results <- r
  if (!is.null(dim(results))) {
    colnames(results) <- list('Model', 'Condition', 'SampleSize', 'NumInd', 'ErrorVar', 'loadings', 'beta', 'Repetition', 'PEstimator', 'Outer', 'Inner', 'pred.method', 'Q2')
    write.csv(as.data.frame(results), file=paste('predict.', model,'n',n,'i',i,'e',e,'l',l,'b',b,'partial.', fname.stem, '.csv', sep=''), row.names=F)
  }
  results
}

run.simulation <- function(fname.stem, num.samples) {
     results <- NULL
    for (model in c('M3')) {
  	  for (s in c(100, 250, 750)) {
#  	  for (s in c(250)) {
	    for (i in c(3, 5, 7)) {
#	    for (i in c(5)) {
	      for (e in c(.1)) {
	        for (l in c(0.75, 1, 1.25)) {
	          for (b in c(.75)) {
                print(paste(model, 'n',s,'i',i,'e',e,'l',l,'b',b,sep=' '))
				flush.console()
                results <- rbind(results, run.model(model, i, e, l, b, s, num.samples, fname.stem))
              }
            }
          }
        }
      }
	}

	rownames(results) <- NULL
     results.frame <- as.data.frame(results)
     write.csv(results.frame, file=paste(fname.stem, '.csv', sep=''), row.names=F)
	results.frame <- read.csv(file=paste(fname.stem, '.csv', sep=''))
}

registerDoParallel(cores=4)
run.simulation('prediction.reflective.condition2', 500)

