     fname.stem <- 'prediction.reflective.200reps.condition0.lavaansim'

	results.frame <- read.csv(file=paste(fname.stem, '.csv', sep=''))
	results.frame <- na.omit(results.frame)

    	a <- aggregate(results.frame[,13], list(Model=results.frame$Model, Condition=results.frame$Condition, SampleSize=results.frame$SampleSize, NumInd=results.frame$NumInd, ErrorVar=results.frame$ErrorVar, loadings=results.frame$loadings, beta=results.frame$beta, PEstimator=results.frame$PEstimator, Inner=results.frame$Inner, Outer=results.frame$Outer, pred.method=results.frame$pred.method), mean)
     write.csv(a, file=paste('aggregate.', fname.stem, '.means.csv', sep=''), row.names=F)

    	a <- aggregate(results.frame[,13], list(Model=results.frame$Model, Condition=results.frame$Condition, SampleSize=results.frame$SampleSize, NumInd=results.frame$NumInd, ErrorVar=results.frame$ErrorVar, loadings=results.frame$loadings, beta=results.frame$beta, PEstimator=results.frame$PEstimator, Inner=results.frame$Inner, Outer=results.frame$Outer, pred.method=results.frame$pred.method), var)
     write.csv(a, file=paste('aggregate.', fname.stem, '.variances.csv', sep=''), row.names=F)

    	a <- aggregate(results.frame[,13], list(Model=results.frame$Model, Condition=results.frame$Condition, SampleSize=results.frame$SampleSize, NumInd=results.frame$NumInd, ErrorVar=results.frame$ErrorVar, loadings=results.frame$loadings, beta=results.frame$beta, PEstimator=results.frame$PEstimator, Inner=results.frame$Inner, Outer=results.frame$Outer, pred.method=results.frame$pred.method), length)
     write.csv(a, file=paste('aggregate.', fname.stem, '.count.csv', sep=''), row.names=F)

    	a <- aggregate(results.frame[,13], list(Model=results.frame$Model, Condition=results.frame$Condition, SampleSize=results.frame$SampleSize, NumInd=results.frame$NumInd, ErrorVar=results.frame$ErrorVar, loadings=results.frame$loadings, beta=results.frame$beta, PEstimator=results.frame$PEstimator, Inner=results.frame$Inner, Outer=results.frame$Outer, pred.method=results.frame$pred.method), sd)
     write.csv(a, file=paste('aggregate.', fname.stem, '.sd.csv', sep=''), row.names=F)

    	b <- aggregate(a[,12], list(Condition=a$Condition, SampleSize=a$SampleSize, NumInd=a$NumInd, ErrorVar=a$ErrorVar, loadings=a$loadings, beta=a$beta, PEstimator=a$PEstimator, Inner=a$Inner, Outer=a$Outer), mean)
     write.csv(b, file=paste('aggregate.', fname.stem, '.sd.no_mode.no_predmethod.csv', sep=''), row.names=F)

	a <- results.frame
	t.test.results <- NULL

	# pairwise t.tests
	for (model in levels(as.factor(a$Model))) {
		for (condition in levels(as.factor(a$Condition))) {
			for (samplesize in levels(as.factor(a$SampleSize))) {
				for (numind in c(3,5,7)) {
					for (errorvar in levels(as.factor(a$ErrorVar))) {
						for (loading in levels(as.factor(a$loadings))) {

							a.sub <- a[a$Model == model & a$Condition == condition & a$SampleSize == samplesize & a$NumInd == numind & a$ErrorVar == errorvar & a$loadings == loading,]

							s <- data.frame(cbind(	a.sub[a.sub$Outer == 'EM',]$Q2, 
												a.sub[a.sub$Outer == 'ML' & a.sub$pred.method == 'comm',]$Q2,
												a.sub[a.sub$Outer == 'ML' & a.sub$pred.method == 'red',]$Q2,
												a.sub[a.sub$Outer == 'outer.modeA' & a.sub$PEstimator == 'params.plsc' & a.sub$pred.method == 'comm',]$Q2,
												a.sub[a.sub$Outer == 'outer.modeA' & a.sub$PEstimator == 'params.plsc' & a.sub$pred.method == 'red',]$Q2,
												a.sub[a.sub$Outer == 'outer.modeA' & a.sub$PEstimator == 'params.regression' & a.sub$pred.method == 'comm',]$Q2,
												a.sub[a.sub$Outer == 'outer.modeA' & a.sub$PEstimator == 'params.regression' & a.sub$pred.method == 'red',]$Q2,
												a.sub[a.sub$Outer == 'outer.modeB' & a.sub$PEstimator == 'params.plsc' & a.sub$pred.method == 'comm',]$Q2,
												a.sub[a.sub$Outer == 'outer.modeB' & a.sub$PEstimator == 'params.plsc' & a.sub$pred.method == 'red',]$Q2,
												a.sub[a.sub$Outer == 'outer.modeB' & a.sub$PEstimator == 'params.regression' & a.sub$pred.method == 'comm',]$Q2,
												a.sub[a.sub$Outer == 'outer.modeB' & a.sub$PEstimator == 'params.regression' & a.sub$pred.method == 'red',]$Q2 ) )

							if ( ((model=='M1' | model=='M2') & numind > 5) | (model=='M3' & numind > 3) ) {
								# We don't have EM data for these models
								colnames(s) <- c('ML.comm', 'ML.red', 'PLSC.A.comm', 'PLSC.A.red', 'PLSPM.A.comm', 'PLSPM.A.red', 'PLSC.B.comm', 'PLSC.B.red', 'PLSPM.B.comm', 'PLSPM.B.red')
							}
							else
							{
								colnames(s) <- c('EM', 'ML.comm', 'ML.red', 'PLSC.A.comm', 'PLSC.A.red', 'PLSPM.A.comm', 'PLSPM.A.red', 'PLSC.B.comm', 'PLSC.B.red', 'PLSPM.B.comm', 'PLSPM.B.red')
							}

							s <- s[, order(-colMeans(s))]

							for (c in 2:ncol(s) ) {
								test.result <- t.test(s[,c-1], s[,c], paired=TRUE)
								t.test.results <- rbind(t.test.results, cbind(model, condition, samplesize, numind, errorvar, loading, colnames(s)[c-1], colnames(s)[c], test.result$p.value, test.result$parameter, test.result$statistic, test.result$estimate))	
							}

							d <- list()
							for ( e in 1:ncol(s)) {
								d[[e]] <- density(s[, e])
							}

							min.x = max(0, min(unlist(lapply(d, function(X) { min(X$x) } ))))
							max.x = max(unlist(lapply(d, function(X) { max(X$x) } )))
							min.y = 0
							max.y = max(unlist(lapply(d, function(X) { max(X$y) } )))

							jpeg(filename=paste("Q2.density.model", model, ".condition", condition, ".n", samplesize, ".i", numind, ".e", errorvar, ".l", loading, ".jpeg", sep=''), width=1000, height=1000, res=150)
							par(mar=c(5.1, 4.1, 4.1, 11.1), xpd=TRUE)
							colors = c("black", "blue", "green", "red", "yellow", "purple", "cyan", "tan", "pink", "orange", "magenta")
							plot(d[[1]], lwd=2, xlim=c(min.x, max.x), ylim=c(min.y, max.y), col=colors[1], main=paste("Q2 density for model ", model, ", n=", samplesize, ", i=", numind, ", e=", errorvar, "l=", loading, sep=''), sub='', ylab='')
							
							for (e in 2:ncol(s)) {
								lines(d[[e]], lwd=2, col=colors[e], xpd=FALSE)
							}
							legend(x="topright", legend=colnames(s), fill=colors, col=colors, border="black", inset=c(-0.5,0) )
							par(xpd=FALSE)
							dev.off()
						}
					}
				}
			}
		}
	}

	colnames(t.test.results) <- c('Model', 'Condition', 'SampleSize', 'NumInd', 'ErrorVar', 'Loading', 'A', 'B', 'P.Value', 'DF', 'T', 'MeanDiff')

	write.csv(t.test.results, file=paste(fname.stem, '.t.test.results.csv', sep=''), row.names=F)
	t.test.results <- read.csv(file=paste(fname.stem, '.t.test.results.csv', sep=''))
	write.csv(format(t.test.results, scientific=FALSE, digits=5), file=paste(fname.stem, '.t.test.results.csv', sep=''), row.names=F)

     a <- read.csv(paste('aggregate.', fname.stem, '.means.csv', sep=''))
	a$SampleSize <- as.factor(a$SampleSize)
	a$NumInd <- as.factor(a$NumInd)
	a$loadings <- as.factor(a$loadings)
	a$ErrorVar <- as.factor(a$ErrorVar)
	a$beta <- as.factor(a$beta)

library(tables)

t1 <- tabular( SampleSize*NumInd*loadings~pred.method*x*(mean), data=a[a$Model=='M1' & a$PEstimator=='ML',])
t2 <- tabular( SampleSize*NumInd*loadings~pred.method*x*(mean), data=a[a$Model=='M1' & a$PEstimator=='params.plsc' & a$Outer=='outer.modeA',])
t3 <- tabular( SampleSize*NumInd*loadings~pred.method*x*(mean), data=a[a$Model=='M1' & a$PEstimator=='params.plsc' & a$Outer=='outer.modeB',])
t4 <- tabular( SampleSize*NumInd*loadings~pred.method*x*(mean), data=a[a$Model=='M1' & a$PEstimator=='params.regression' & a$Outer=='outer.modeA',])
t5 <- tabular( SampleSize*NumInd*loadings~pred.method*x*(mean), data=a[a$Model=='M1' & a$PEstimator=='params.regression' & a$Outer=='outer.modeB',])
t <- cbind(t1, t2, t3, t4, t5)

write.csv.tabular(t, 'mean.tables.M1.csv', row.names=FALSE)

t1 <- tabular( SampleSize*NumInd*loadings~pred.method*x*(mean), data=a[a$Model=='M2' & a$PEstimator=='ML',])
t2 <- tabular( SampleSize*NumInd*loadings~pred.method*x*(mean), data=a[a$Model=='M2' & a$PEstimator=='params.plsc' & a$Outer=='outer.modeA',])
t3 <- tabular( SampleSize*NumInd*loadings~pred.method*x*(mean), data=a[a$Model=='M2' & a$PEstimator=='params.plsc' & a$Outer=='outer.modeB',])
t4 <- tabular( SampleSize*NumInd*loadings~pred.method*x*(mean), data=a[a$Model=='M2' & a$PEstimator=='params.regression' & a$Outer=='outer.modeA',])
t5 <- tabular( SampleSize*NumInd*loadings~pred.method*x*(mean), data=a[a$Model=='M2' & a$PEstimator=='params.regression' & a$Outer=='outer.modeB',])
t <- cbind(t1, t2, t3, t4, t5)

write.csv.tabular(t, 'mean.tables.M2.csv', row.names=FALSE)

t1 <- tabular( SampleSize*NumInd*loadings~pred.method*x*(mean), data=a[a$Model=='M3' & a$PEstimator=='ML',])
t2 <- tabular( SampleSize*NumInd*loadings~pred.method*x*(mean), data=a[a$Model=='M3' & a$PEstimator=='params.plsc' & a$Outer=='outer.modeA',])
t3 <- tabular( SampleSize*NumInd*loadings~pred.method*x*(mean), data=a[a$Model=='M3' & a$PEstimator=='params.plsc' & a$Outer=='outer.modeB',])
t4 <- tabular( SampleSize*NumInd*loadings~pred.method*x*(mean), data=a[a$Model=='M3' & a$PEstimator=='params.regression' & a$Outer=='outer.modeA',])
t5 <- tabular( SampleSize*NumInd*loadings~pred.method*x*(mean), data=a[a$Model=='M3' & a$PEstimator=='params.regression' & a$Outer=='outer.modeB',])
t <- cbind(t1, t2, t3, t4, t5)

write.csv.tabular(t, 'mean.tables.M3.csv', row.names=FALSE)

