library(MASS)
library(Matrix)
library(lavaan)
library(plspm)
library(matrixpls)
library(norm)
library(numbers)
library(doParallel)
library(foreach)

source('setup.models.generate.R')
source('setup.models.R')
source('lavaan.blindfold.R')
source('imp.blindfold.R')
source('matrixpls.blindfold.R')

run.model <- function(model, i=3, e=0.1, l=0.75, b=0.25, n=250, num.samples=1, fname.stem) {

 if (model=="M1") {
   blind.con <- c('x', 'y')
   lavaan.model <- build.model1.lavaan(i)
   generating.model <- build.model1.lavaan.generate(i, b, l, e)
 }
 if (model=="M2") {
   blind.con <- c('w', 'x', 'y', 'z')
   lavaan.model <- build.model2.lavaan(i)
   generating.model <- build.model2.lavaan.generate(i, b, l, e)
 }
 if (model=="M3") {
   blind.con <- c('k', 'l', 'x', 'y', 'z')
   lavaan.model <- build.model3.lavaan(i)
   generating.model <- build.model3.lavaan.generate(i, b, l, e)
 }

#   r <- NULL
   results <- foreach (scount=1:num.samples,.combine=rbind, 
                    	.export=c('matrixpls.blindfold', 'lavaan.blindfold', 'imp.blindfold'), 
					.packages=c('matrixpls', 'lavaan', 'norm', 'MASS', 'Matrix', 'numbers')) %dopar% {
#   for (scount in 1:num.samples) {
       print(paste("Sample", scount))

       data <- simulateData(generating.model, standardized=FALSE)
	  
	  omission.dist <- nextPrime(i)
	  if ( (length(blind.con) * i) %% omission.dist == 0) {
		omission.dist <- omission.dist + 1
	  }
       r <- NULL

       for (parameterEstimator in c('params.plsc', 'params.regression') ) {
         for (outerEstimator in c('outer.modeA', 'outer.modeB') ) {
           for (innerEstimator in c('inner.centroid') ) {
			 repcount = 0
                repeat {
                  bfold <- matrixpls.blindfold(lavaan.model, data, blind.con, omission.dist, outerEstimators=get(outerEstimator), innerEstimator=get(innerEstimator), parameterEstimator=get(parameterEstimator))
                  bfold <- replace(bfold, bfold < -1, NA)
                  if ( (!is.na(bfold[1]) & !is.na(bfold[2])) | repcount > 5 ) break
                  print("Repeating PLS")
                  repcount <- repcount+1
               }
               r <- rbind(r, c(model, 0, n, i, e, l, b, scount, parameterEstimator, outerEstimator, innerEstimator, 'comm', bfold[1]))
               r <- rbind(r, c(model, 0, n, i, e, l, b, scount, parameterEstimator, outerEstimator, innerEstimator, 'red', bfold[2]))
           }
         }
       }

       repcount = 0
 	  repeat {
	    bfold <- lavaan.blindfold(lavaan.model, data, blind.con, omission.dist)
	    if (!is.nan(bfold)) { 
           bfold <- replace(bfold, bfold < -1, NA)
           if(!is.na(bfold) | repcount>5) break
	    }
	    print("Repeating ML")
         repcount <- repcount+1
	  }
       r <- rbind(r, c(model, 0, n, i, e, l, b, scount, 'ML', 'ML', 'ML', 'comm', bfold[1]))
       r <- rbind(r, c(model, 0, n, i, e, l, b, scount, 'ML', 'ML', 'ML', 'red', bfold[2]))

	  # From experience, EM will not converge for 7 indicators, so don't even try
       if (i < 7) {
		  browser()
            repcount = 0
		  repeat
		  {
			bfold <- NaN
			try(bfold <- imp.blindfold(lavaan.model, data, blind.con, omission.dist), silent=TRUE)
			if (!is.nan(bfold)) {
		       bfold <- replace(bfold, bfold < -1, NA)
		       if(!is.na(bfold)) break
		     }
			repcount <- repcount+1
			if (repcount>5) break
			print("Repeating EM")
		  }
		  if (!is.nan(bfold) & !is.na(bfold))
		    r <- rbind(r, c(model, 0, n, i, e, l, b, scount, 'EM', 'EM', 'EM', 'EM', bfold))
	  }
       r
  }
#  results <- r
  if (!is.null(dim(results))) {
    colnames(results) <- list('Model', 'Condition', 'SampleSize', 'NumInd', 'ErrorVar', 'loadings', 'beta', 'Repetition', 'PEstimator', 'Outer', 'Inner', 'pred.method', 'Q2')
    write.csv(as.data.frame(results), file=paste('predict.', model,'n',n,'i',i,'e',e,'l',l,'b',b,'partial.', fname.stem, '.csv', sep=''), row.names=F)
  }
  results
}

run.simulation <- function(fname.stem, num.samples) {
     results <- NULL
    for (model in c('M1', 'M2', 'M3')) {
#    for (model in c('M1')) {
  	  for (s in c(100, 250, 750)) {
#  	  for (s in c(250)) {
	    for (i in c(3, 5, 7)) {
#	    for (i in c(5)) {
	      for (l in c(0.75, 1.0, 1.25)) {
		   for (e in c(0.1)) {
  	          for (b in c(.75)) {
                 print(paste(model, 'n',s,'i',i,'e', e, 'l',l,'b',b,sep=' '))
                 results <- rbind(results, run.model(model, i, e, l, b, s, num.samples, fname.stem))
               }
             }
           }
         }
       }
	}

	rownames(results) <- NULL
     results.frame <- as.data.frame(results)
     write.csv(results.frame, file=paste(fname.stem, '.csv', sep=''), row.names=F)
	results.frame <- read.csv(file=paste(fname.stem, '.csv', sep=''))
}

registerDoParallel(cores=32)
run.simulation('prediction.reflective.100reps.condition0.lavaansim.SetB', 100)

