//
//  ConfigController.java
//  InfoBoard
//
//  Created by Joerg Evermann on 22/06/05.
//  Copyright 2005 __MyCompanyName__. All rights reserved.
//

import java.util.*;
import javax.xml.parsers.*;


public class ConfigController {
	
	private Vector		runs;
	protected String		logfile;
	protected String		soundfile;
	protected String		initialMessage;
	protected int		fontsize;
	protected String		fontface;
	protected boolean	fontbold;

	
	public ConfigController() {
		runs = new Vector();
		logfile = "log.txt";
		soundfile = "sound.wav";
		initialMessage = "Press OK to begin.";
		fontsize = 0;
		fontface = null;
	}
	
	public void addRun(RunInfo run) {
		runs.add(run);
	}
	
	public int getNum() {
		return runs.size();	
	}
	
	public RunInfo getRun(int i) {
		return (RunInfo)runs.get(i);
	}
	

	// Reads and parses and XML file containing the MatchingController description
    boolean ReadCtrl(String controlFileName) {
        SAXParserFactory    theFactory = SAXParserFactory.newInstance();
        SAXParser           theParser;
        SAXConfigHandler	theHandler = new SAXConfigHandler(this);
        
        try { 
            theFactory.setValidating(true);
            theParser = theFactory.newSAXParser();
            theParser.parse(controlFileName, theHandler);
            return true;
        }
        catch (Exception e) {e.printStackTrace(); System.exit(-1); return false;}
	}
}
