//
//  ImageCanvas.java
//  InfoBoard
//
//  Created by Joerg Evermann on 22/06/05.
//  Copyright 2005 __MyCompanyName__. All rights reserved.
//

import java.awt.*;

public class ImageCanvas extends Canvas {
	
	private Image	image;
	private String	instructions;
	
	public ImageCanvas(String inst) {
		super();
		this.image = null;
		this.instructions = inst;
	}
		
    public void paint(Graphics g) {
		if (image != null) {
			// draw a centered image
			int h = image.getHeight(null);
			int w = image.getWidth(null);
			g.drawImage(image, (getWidth()-w)/2, (getHeight()-h)/2, this);
		} else {
			// draw centered instructions, if any
			if (instructions != null) {
				int h = (int)g.getFontMetrics().getStringBounds(instructions, g).getHeight();
				int w = (int)g.getFontMetrics().getStringBounds(instructions, g).getWidth();
				g.drawString(instructions, (getWidth()-w)/2, (getHeight()-h)/2);
			}
		}
    }

	public void setImage(Image img) {
		this.image = img;
	}
	
}
