//
//  InfoBoard.java
//  InfoBoard
//
//  Created by Joerg Evermann on 22/06/05.
//  Copyright (c) 2005 __MyCompanyName__. All rights reserved.
//
import java.io.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class InfoBoard extends java.awt.Frame {

	private	Panel				buttonPanel, scalePanel;
	private	ImageCanvas			imageCanvas;
	private CheckboxGroup			response;
	private RunInfo				currentRun;
	private	int					currentRunNum;
	private ConfigController		theController;
	private SoundRecorder			theRecorder;
	private Label				questionLabel;
	
	public InfoBoard(String controlFileName) {
		// undecorate this frame
//		this.setUndecorated(true);
		// Read the config file
		theController = new ConfigController();
		theController.ReadCtrl(controlFileName);		
		// erase the logfile if it exists
		File f = new File(theController.logfile);
		theRecorder = new SoundRecorder(theController.soundfile);
		f.delete();
		// handle the window close event
		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				System.exit(0);
			}
		});
		
		Font ff;
		if ( (theController.fontface != null) && (theController.fontsize > 0) ) {
			if ( theController.fontbold )
				ff = new Font(theController.fontface, java.awt.Font.BOLD, theController.fontsize);
			else
				ff = new Font(theController.fontface, java.awt.Font.PLAIN, theController.fontsize);
			this.setFont(ff);
		}
		currentRunNum = 0;
		advanceRun();
	}
	
	protected void advanceRun() {
		if (currentRunNum < theController.getNum()) {
			if (currentRun != null) {
	        		// log the end of the current run to the logfile
	    			try {
	    				PrintStream PStream = new PrintStream(new FileOutputStream( theController.logfile, true ));
	    				PStream.print( currentRunNum );
	    				PStream.print( "\t End \t" );
	    				PStream.print( System.currentTimeMillis() );
	    				PStream.print( "\n" );
	    				PStream.close();
	    			} catch (Exception ex) {
	    				ex.printStackTrace();
	    			}
				JOptionPane.showMessageDialog(null, currentRun.finalMessage, "Information", JOptionPane.INFORMATION_MESSAGE);
			}
			else {
				JOptionPane.showMessageDialog(null, theController.initialMessage, "Information", JOptionPane.INFORMATION_MESSAGE);
				theRecorder.StartRecording();
			}
			// clear the window from the previous run, if any
			clearWindow();
			// Get the current run info from the controller
			currentRun = theController.getRun(currentRunNum);
			// Create a canvas to draw on
			imageCanvas = new ImageCanvas(currentRun.instructions);
			// Construct the button panel
			constructButtonPanel();
			// Construct the question panel
			constructQuestionLabel();
			// Construct the scale panel
			constructScalePanel();
			// size everything and add to frame
			showWindow();
			// Log the beginning of the run to the logfile
			try {
				PrintStream PStream = new PrintStream(new FileOutputStream( theController.logfile, true ));
				PStream.print( currentRunNum );
				PStream.print( "\t Begin \t" );
				PStream.print( System.currentTimeMillis() );
				PStream.print( "\n" );
				PStream.close();
			} catch (Exception ex) {
				ex.printStackTrace();
			}
			// and advance the current run number
			currentRunNum++;
		} else {
			theRecorder.StopRecording();
			JOptionPane.showMessageDialog(null, currentRun.finalMessage, "Information", JOptionPane.INFORMATION_MESSAGE);
			System.exit(0);
		}
	}
	
	private void clearWindow() {
		// set invisible
		this.setVisible(false);
		// remove all components from containers
		if (buttonPanel != null) buttonPanel.removeAll();
		if (scalePanel != null) scalePanel.removeAll();
		// remove all containers from this frame
		this.removeAll();
		// clear everything for gc
		imageCanvas = null;
		buttonPanel = null;
		questionLabel = null;
		scalePanel = null;
	}
	
	private void showWindow() {
		// get graphics device and screen dimensions
		GraphicsEnvironment	ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
		GraphicsDevice		gd = ge.getDefaultScreenDevice();
		int screenwidth = gd.getDisplayMode().getWidth();
		int screenheight = gd.getDisplayMode().getHeight();

		// find the height and width of the images
		int maxImageWidth = 0;
		int maxImageHeight = 0;
		for (int i = 0; i < buttonPanel.getComponents().length; i++) {
			if ( ((InfoButtonListener)buttonPanel.getComponent(i).getMouseListeners()[0]).getImageHeight() > maxImageHeight)
				maxImageHeight = ((InfoButtonListener)buttonPanel.getComponent(i).getMouseListeners()[0]).getImageHeight();
			if ( ((InfoButtonListener)buttonPanel.getComponent(i).getMouseListeners()[0]).getImageWidth() > maxImageWidth)
				maxImageWidth = ((InfoButtonListener)buttonPanel.getComponent(i).getMouseListeners()[0]).getImageWidth();
		}
		// set the canvas size to the maximum we'll need
		imageCanvas.setSize(maxImageWidth, maxImageHeight);
		imageCanvas.validate();
		// set the layout for this frame
		this.setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
		// and add the conponents
		this.add(questionLabel);
		this.add(scalePanel);
		this.add(imageCanvas);
		this.add(buttonPanel);
		// lay it out
		this.pack();
		// make it non-resizable
		this.setResizable(false);
		// center it
		this.setLocation( (screenwidth - this.getWidth())/2, (screenheight - this.getHeight())/2);
		// make it visible
		this.setVisible(true);
	}
	
	private void constructButtonPanel() {
		buttonPanel = new Panel();
		// Set the layout for the button panel
		buttonPanel.setLayout(new BoxLayout(buttonPanel, BoxLayout.X_AXIS));
		// Add the buttons for displaying the information
		for (int i = 0; i < currentRun.getNum(); i++) {
			Button	b = new Button(currentRun.getLabel(i));
			b.addMouseListener(new InfoButtonListener(imageCanvas, currentRun.getLabel(i), currentRun.getFile(i), currentRun.scaleimages, theController.logfile));
			buttonPanel.add(b);
		}
	}
	
	private void constructQuestionLabel() {
		// Create a label for the question
		questionLabel = new Label(currentRun.question, Label.CENTER);
	}

	private void constructScalePanel() {
		// Create a panel for the scale
		scalePanel = new Panel();
		// Set the layout for the scale panel
		scalePanel.setLayout(new BoxLayout(scalePanel, BoxLayout.X_AXIS));
		// Add the low anchor label to the question panel
		scalePanel.add(new Label(currentRun.lowanchor));
		// create a group for the radio buttons of the likert scale
		response = new CheckboxGroup();		
		// insert the buttons of the likert scale
		for (int i = 0; i < currentRun.scalepoints; i++) {
			Checkbox c = new Checkbox(null, false, response);
			c.addMouseListener(new InfoCheckboxListener(i, theController.logfile));
			scalePanel.add(c);
		}
		// insert the high anchor
		scalePanel.add(new Label(currentRun.highanchor));
		// Create a done Button
		Button doneButton = new Button("Done");
		doneButton.addMouseListener(new MouseAdapter() {
            public void mouseClicked(MouseEvent e) {
				if (response.getSelectedCheckbox() != null)
					advanceRun();
				else
					JOptionPane.showMessageDialog(null, "You must select a response to the question", "Alert", JOptionPane.ERROR_MESSAGE);
				}});
		scalePanel.add(doneButton);
	}
	
    public static void main (String args[]) {
    		if (args.length == 1)
    			new InfoBoard(args[0]).show();
		if (args.length == 0)
			new InfoBoard("InfoBoardControl.xml").show();
		if (args.length > 1)
			System.err.println("usage: java -jar InfoBoard.jar controlfilename");
	}
}
