//
//  InfoButtonListener.java
//  InfoBoard
//
//  Created by Joerg Evermann on 22/06/05.
//  Copyright 2005 __MyCompanyName__. All rights reserved.
//

import java.awt.*;
import java.awt.event.*;
import java.io.*;

public class InfoButtonListener extends java.awt.event.MouseAdapter {
	
	private ImageCanvas	canvas;
	private	Image		image, scaledimage;
	private String		label;
	private String		file;
	private String		logfile;
	private boolean		scale;
	
	public InfoButtonListener(ImageCanvas c, String l, String f, boolean scale, String logfile) {
		super();

		this.canvas = c;
		this.label = l;
		this.file = f;
		this.logfile = logfile;
		this.scale = scale;
		
		// Load the image file, and wait for it to load completely
		MediaTracker media = new MediaTracker(canvas);
        image = Toolkit.getDefaultToolkit().getImage(file);
        media.addImage(image, 0);
        try {
            media.waitForID(0);
        }
        catch (InterruptedException e) {
            System.err.println("unable to load " + file + " - " + e.getMessage());
            System.exit(-1);
        }
	}
	
	public int getImageHeight() {
		return image.getHeight(null);
	}
	
	public int getImageWidth() {
		return image.getWidth(null);
	}
	
	private void setCanvasImageOn() {
		// Check whether scaling is necessary
		if (scale) {
			if (scaledimage == null && image != null) {

				double imageaspect = (double)image.getWidth(null)/(double)image.getHeight(null);
				double canvasaspect = (double)canvas.getWidth()/(double)canvas.getHeight();
				
				// preserve aspect ratio of image
				if (imageaspect > canvasaspect)
					scaledimage = image.getScaledInstance(canvas.getWidth(), -1, Image.SCALE_SMOOTH);
				else
					scaledimage = image.getScaledInstance(-1, canvas.getHeight(), Image.SCALE_SMOOTH);
				// wait for the scaled image to be ready
				MediaTracker media = new MediaTracker(canvas);
				media.addImage(scaledimage, 0);
				try {
					media.waitForID(0);
				}
				catch (InterruptedException e) {
					System.err.println("unable to load " + file + " - " + e.getMessage());
					System.exit(-1);
				}				
			}
			canvas.setImage(scaledimage);
		} else {
			canvas.setImage(image);
		}
		canvas.repaint();
	}
	
	private void setCanvasImageOff() {
		canvas.setImage(null);
		canvas.repaint();
	}
	
	public void mousePressed(MouseEvent e) {
		setCanvasImageOn();
		
		try {
			PrintStream PStream = new PrintStream(new FileOutputStream( logfile, true ));
			PStream.print( this.label );
			PStream.print( "\t On \t" );
			PStream.print( System.currentTimeMillis() );
			PStream.print( "\n" );
			PStream.close();			
		} catch (Exception ex) {
			ex.printStackTrace();
			System.exit(-1);
		}
	}
	
	public void mouseReleased(MouseEvent e) {
		setCanvasImageOff();
		
		try {
			PrintStream PStream = new PrintStream(new FileOutputStream( logfile, true ));
			PStream.print( this.label );
			PStream.print( "\t Off \t" );
			PStream.print( System.currentTimeMillis() );
			PStream.print( "\n" );
			PStream.close();
		} catch (Exception ex) {
			ex.printStackTrace();
			System.exit(-1);
		}
	}
	
}
