//
//  SAXConfigHandler.java
//  InfoBoard
//
//  Created by Joerg Evermann on 22/06/05.
//  Copyright 2005 __MyCompanyName__. All rights reserved.
//

import org.xml.sax.helpers.*;

public class SAXConfigHandler extends DefaultHandler {
	
	private int					state;
	private ConfigController	ctrl;
	private	String				file;
	private String				label;
	private String				buffer;
	private RunInfo				run;

	/** Creates a new instance of SAXConfigHandler */
	public SAXConfigHandler(ConfigController ctrl) {
		this.ctrl = ctrl;
		state = 0;
		file = null;
		label = null;
		run = null;
		buffer = new String();
	}

    public void characters(char[] values, int start, int length) {
        // Received some characters, add to buffer
		buffer = buffer.concat(String.copyValueOf(values, start, length));
	}
	
	public void endElement(String nameSpaceURI, String localName, String qName) {
		String s = buffer;
		buffer = new String();
		
		switch (state) {
			case 1 : {
				// coming out of infoboardcontrol tag
				break;
			}
			case 100 : {
				// coming out of a run tag, add it to the controller
				ctrl.addRun(run);
				run = null;
				state = 1;
				break;
			}
			case 2 : {
				// coming out of an infoboard tag
				state = 100;
				break;
			}	
			case 3 : {
				// coming out of a label tag
				file = s;
				if (file != null && label != null) {
					run.addEntry(file, label);
					state = 2;
					file = null;
					label = null;
				} else {
					state = 2;
				}
				break;
			}
			case 4 : {
				label = s;
				if (file != null && label != null) {
					run.addEntry(file, label);
					state = 2;
					file = null;
					label = null;
				} else {
					state = 2;
				}
				break;
			}
			case 5 : {
				// coming out of a logfile tag
				ctrl.logfile = s;
				state = 1;
				break;
			}
			case 6 : {
				// coming out of a question tag
				run.question = s;
				state = 100;
				break;
			}
			case 7 : {
				// coming out of a highanchor tag
				run.highanchor = s;
				state = 100;
				break;
			}
			case 8 : {
				// coming out of a lowanchor tag
				run.lowanchor = s;
				state = 100;
				break;
			}
			case 9 : {
				// coming out of a scalepoints tag
				run.scalepoints = Integer.parseInt(s);
				state = 100;
				break;
			}
			case 10 : {
				// coming out of a scaleimages tag
				run.scaleimages = (Boolean.valueOf(s)).booleanValue();
				state = 100;
				break;
			}
			case 11 : {
				// coming out of an instructions tag
				run.instructions = s;
				state = 100;
				break;
			}
			case 12 : {
				// coming out of a finalMessage tag
				run.finalMessage = s;
				state =100;
				break;
			}
			case 13 : {
				// coming out of an initialMessage tag
				ctrl.initialMessage = s;
				state = 1;
				break;
			}
			case 14 : {
				// coming out of a SoundFile tag
				ctrl.soundfile = s;
				state = 1;
				break;
			}
			case 15 : {
				// coming out of a FontSize tag
				ctrl.fontsize = Integer.parseInt(s);
				state = 1;
				break;
			}
			case 16 : {
				// coming out of a Font tag
				ctrl.fontface = s;
				state = 1;
				break;
			}
			case 17 : {
				// coming out of a FontBold tag
				ctrl.fontbold = (Boolean.valueOf(s)).booleanValue();
				state = 1;
				break;
			}
		}
	}
	
	public void startElement(String str, String str1, String str2, org.xml.sax.Attributes attributes) {
		if (str2 == "InfoBoardControl" && state == 0) state = 1;
		if (str2 == "LogFile" && state == 1) state = 5;
		if (str2 == "FontSize" && state == 1) state = 15;
		if (str2 == "Font" && state == 1) state = 16;
		if (str2 == "FontBold" && state == 1) state =17;
		if (str2 == "InitialMessage" && state == 1) state = 13;
		if (str2 == "SoundFile" && state ==1) state =14;
		if (str2 == "Run" && state == 1) { run = new RunInfo(); state = 100; }
		if (str2 == "InfoBoard" && state == 100) state = 2;
		if (str2 == "File" && state == 2) state = 3;
		if (str2 == "Label" && state == 2) state = 4;
		if (str2 == "Question" && state == 100) state = 6;
		if (str2 == "HighAnchor" && state == 100) state = 7;
		if (str2 == "LowAnchor" && state == 100) state = 8;
		if (str2 == "ScalePoints" && state ==100) state = 9;
		if (str2 == "ScaleImages" && state ==100) state =10;
		if (str2 == "Instructions" && state ==100) state =11;
		if (str2 == "FinalMessage" && state ==100) state =12;
		buffer = new String();
	}
}
