import java.io.IOException;
import java.io.File;

import javax.sound.sampled.*;

public class SoundRecorder extends Thread
{
	private	File					outputFile;
	private	AudioInputStream		inputStream;
	private	TargetDataLine		line;

	public SoundRecorder(String soundfilename) {
		AudioFormat		af;
		DataLine.Info	dlinfo;

		// Create output file
		outputFile = new File(soundfilename);
		// Create the audio format (regular CD quality WAVE)
		af = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 44100.0F, 16, 2, 4, 44100.0F, false);
		// Create the info for the data line
		dlinfo = new DataLine.Info(TargetDataLine.class, af);
		// The acquire the data line from the Audio System
		try {
			line = (TargetDataLine)AudioSystem.getLine(dlinfo);
			line.open(af);
		} catch (LineUnavailableException e) {
			e.printStackTrace();
			System.exit(-1);
		}
		// and then make an input stream on the line
		inputStream = new AudioInputStream(line);
	}

	public void StartRecording() {
		// start the data line
		line.start();
		// start the thread
		super.start();
	}

	public void StopRecording() {
		// stop the data line
		line.stop();
		// close the data line, will cause AudioSystem.write 
		// to throw an exception in run() and end that way 
		line.close();
	}
	
	public void run() {
		try {
			AudioSystem.write(inputStream, AudioFileFormat.Type.WAVE, outputFile);
		} catch (IOException e) {
		}
	}
}

