package kinesisFHM.commonTypes;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;

public class CNetAugmentation implements Serializable {

	private String 				event;
	private HashSet<String>		others;
	private CNetType			dir;

	private int					hashcode;
	
	public CNetAugmentation() {
		event = new String();
		others = new HashSet<String>();
		dir = CNetType.SUCC;
		
		hashcode = Objects.hash(event, others, dir);
	}
	
	public HashSet<String> getOthers() { return others; }
	public String getEvent() { return event; }
	public CNetType getDir() { return dir; }
	
	public CNetAugmentation(String ev, Collection<String> ot, CNetType dir) {
		event = ev;
		others = new HashSet<String>(ot);
		this.dir = dir;

		hashcode = Objects.hash(event, others, dir);
	}
	
	private void writeObject(java.io.ObjectOutputStream out) throws IOException {
		out.writeObject(event);
		out.writeObject(others);
		out.writeObject(dir);
		out.writeInt(hashcode);
	}

	private void readObject(java.io.ObjectInputStream in) throws IOException, ClassNotFoundException {
		this.event = (String) in.readObject();
		this.others = (HashSet<String>) in.readObject();
		this.dir = (CNetType) in.readObject();
		this.hashcode = in.readInt();
	}

	
	public boolean equals(Object other) {
		if (other instanceof CNetAugmentation) {
			CNetAugmentation o = (CNetAugmentation) other;
			return (event.equals(o.event) && others.equals(o.others) && dir==o.dir );
		} else {
			return false;
		}
	}
	
	public int hashCode() {
		return hashcode;
	}
	
	@Override
	public String toString() {
		return "CnetAugmentation (" + event + "/" + others.toString() + "/" + dir.toString() + ")";
	}
}
