package kinesisFHM.commonTypes;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;

import org.apache.commons.codec.binary.Base64;



public class DependencyRelation implements Serializable {

	private String ev1, ev2;
	private WfRType type;
	private Float dep;
	
	public DependencyRelation() {
		ev1 = new String();
		ev2 = new String();
		type = WfRType.DIRECT;
		dep = new Float(0);
	};
	
	public DependencyRelation(String ev1, String ev2, WfRType type, Float dep) {
		this.ev1 = ev1;
		this.ev2 = ev2;
		this.type = type;
		this.dep = dep;
	}

	public DependencyRelation(String ev1, String ev2, WfRType type) {
		this.ev1 = ev1;
		this.ev2 = ev2;
		this.type = type;
		this.dep = 1f;
	}

	public void set (String ev1, String ev2, WfRType type, Float dep) {
		this.ev1 = ev1;
		this.ev2 = ev2;
		this.type = type;
		this.dep = dep;
	}
	
	public WfRType getType() {return type;}
	public Float getDep() {return dep; }
	public String getEvent1() { return ev1; }
	public String getEvent2() { return ev2; }
	

	private void writeObject(java.io.ObjectOutputStream out) throws IOException {
		out.writeObject(ev1);
		out.writeObject(ev2);
		out.writeObject(type);
		out.writeObject(dep);
	}

	private void readObject(java.io.ObjectInputStream in) throws IOException, ClassNotFoundException {
		this.ev1 = (String) in.readObject();
		this.ev2 = (String) in.readObject();
		this.type = (WfRType) in.readObject();
		this.dep = (Float) in.readObject();
	}
	
	public byte[] getBase64() {
		ByteArrayOutputStream baos = new ByteArrayOutputStream();
		try {
			new ObjectOutputStream( baos ).writeObject( this );
		} catch (IOException e) {
			return new byte[]{0};
		}
		return Base64.encodeBase64(baos.toByteArray());
	}

	public String toString() {
		return "<" + ev1 + " " + type.toString().substring(0,3) + " " + ev2 + " / " + dep + ">";
	}

}
