/**
 * 
 */
package kinesisFHM.commonTypes;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Timestamp;

import org.apache.commons.codec.binary.Base64;

/**
 * @author joerg
 *
 */
public class Event implements Serializable {

	private String caseID;
	private String eventID;
	private Long TS;
	
	public Event(String caseID, String eventID, Long TS) {
		this.caseID = caseID;
		this.eventID = eventID;
		this.TS = TS;
	}

	private void writeObject(java.io.ObjectOutputStream out) throws IOException {
		out.writeObject(caseID);
		out.writeObject(eventID);
		out.writeObject(TS);
	}

	private void readObject(java.io.ObjectInputStream in) throws IOException, ClassNotFoundException {
		this.caseID = (String)in.readObject();
		this.eventID = (String)in.readObject();
		this.TS = (Long)in.readObject();
	}
	
	public String getCaseID() { return this.caseID; }
	public String getEventID() { return this.eventID; }
	public Long getTS() { return this.TS; }
	
	public byte[] getBase64() {
		ByteArrayOutputStream baos = new ByteArrayOutputStream();
		try {
			new ObjectOutputStream( baos ).writeObject( this );
		} catch (IOException e) {
			return new byte[]{0};
		}
		return Base64.encodeBase64(baos.toByteArray());
	}
	
	public String toString() {
		return new String("<" + caseID + ", " + eventID + ", " + TS);
	}
		
}
