package kinesisFHM.commonTypes;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Objects;

import org.apache.commons.codec.binary.Base64;

public class Relation implements Serializable {

	protected String ev1, ev2;
	protected WfRType type;
	
	public Relation() {
		ev1 = new String();
		ev2 = new String();
		type = WfRType.DIRECT;
	};
	
	public Relation(String ev1, String ev2, WfRType type) {
		this.ev1 = new String(ev1);
		this.ev2 = new String(ev2);
		this.type = type;
	}

	public void set (String ev1, String ev2, WfRType type) {
		this.ev1 = new String(ev1);
		this.ev2 = new String(ev2);
		this.type = type;
	}
	
	public String getEvent1() {return ev1; }
	public String getEvent2() {return ev2; }
	public WfRType getType() {return type;}
	
	private void writeObject(java.io.ObjectOutputStream out) throws IOException {
		out.writeObject(ev1);
		out.writeObject(ev2);
		out.writeObject(type);
	}

	private void readObject(java.io.ObjectInputStream in) throws IOException, ClassNotFoundException {
		this.ev1 = (String) in.readObject();
		this.ev2 = (String) in.readObject();
		this.type = (WfRType) in.readObject();
	}
	
	public int hashCode() {
		return Objects.hash(ev1, ev2, type);
	}
	
	public boolean equals(Object other) {
		if (other == null) return false;
		if (other instanceof Relation) {
			Relation o = (Relation)other;
			return (ev1.equals(o.ev1) && ev2.equals(o.ev2) && type == o.type);
		} else return false;
	}

	public byte[] getBase64() {
		ByteArrayOutputStream baos = new ByteArrayOutputStream();
		try {
			new ObjectOutputStream( baos ).writeObject( this );
		} catch (IOException e) {
			return new byte[]{0};
		}
		return Base64.encodeBase64(baos.toByteArray());
	}

	public String toString() {
		return "<" + ev1 + " " + type.toString() + " " + ev2 + ">";
	}
}
