package kinesisFHM.commonTypes;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Objects;

import org.apache.commons.codec.binary.Base64;

public class RelationCount implements Serializable {

	protected Relation r;
	protected long count;
	
	public RelationCount() {
		r = new Relation();
		count = 0l;
	};
	
	public RelationCount(Relation r, long count) {
		this.r = r;
		this.count = count;
	}

	public void set (Relation r, long count) {
		this.r = r;
		this.count = count;
	}
	
	public void add () {
		this.count++;
	}

	public Relation getRelation() { return r; }
	public long getCount() {return count; }
	
	private void writeObject(java.io.ObjectOutputStream out) throws IOException {
		out.writeObject(r);
		out.writeLong(count);
	}

	private void readObject(java.io.ObjectInputStream in) throws IOException, ClassNotFoundException {
		this.r = (Relation) in.readObject();
		this.count = in.readLong();
	}
	
	public int hashCode() {
		return Objects.hash(r, count);
	}
	
	public boolean equals(Object other) {
		if (other == null) return false;
		if (other instanceof RelationCount) {
			RelationCount o = (RelationCount)other;
			return (r.equals(o.r) && count == o.count);
		} else return false;
	}

	public byte[] getBase64() {
		ByteArrayOutputStream baos = new ByteArrayOutputStream();
		try {
			new ObjectOutputStream( baos ).writeObject( this );
		} catch (IOException e) {
			return new byte[]{0};
		}
		return Base64.encodeBase64(baos.toByteArray());
	}

	public String toString() {
		return "<" + r + " / " + count + ">";
	}
}
