package kinesisFHM.eventGenerator;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;

public class EventGeneratorPersistOnShutdown extends Thread implements Runnable {

	private EventGenerator eg;
	
	public EventGeneratorPersistOnShutdown(EventGenerator eg) {
		super();
		this.eg = eg;
	}
	
	public void run() {
		System.out.println("Shutdown - persistng case numbers");
		File f = new File("EventGenerator.persistedCounts");
		ObjectOutputStream oos;
		try {
			oos = new ObjectOutputStream(new FileOutputStream(f, false));
			oos.writeObject(eg.casenums);
			oos.close();
		} catch (FileNotFoundException e) {
			System.err.println(e.getMessage());			
		} catch (IOException e) {
			System.err.println(e.getMessage());		
		}
		System.out.println("persisting done");
	}
	
}
