package kinesisFHM;

import java.util.Arrays;

import kinesisFHM.eventConsumer.EventConsumer;
import kinesisFHM.eventGenerator.EventGenerator;
import kinesisFHM.graphConsumer.GraphConsumer;
import kinesisFHM.relationConsumer.RelationConsumer;
import kinesisFHM.updateConsumer.UpdateConsumer;

public class kinesisFHM {

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		// TODO Auto-generated method stub
		if (args.length < 3) {
			System.err.println("Usage:\n");
			System.err.println("One of");
			System.err.println("  kinesisFHM.jar EventGenerator credentialFileName awsProfileName bucket object numShards maxCases lambda maxInstances");
			System.err.println("  kinesisFHM.jar EventConsumer credentialFileName awsProfileName numTraceOutputShards numRelationOutputShards inputBatchSize threadsleep [realTime]");
			System.err.println("  kinesisFHM.jar RelationConsumer credentialFileName awsProfileName inputBatchSize threadsleep [minDep]");
			System.err.println("  kinesisFHM.jar UpdateConsumer credentialFileName awsProfileName inputBatchSize threadsleep [defaultThreshold]");
			System.err.println("  kinesisFHM.jar GraphConsumer credentialFileName awsProfileName threadsleep [graphTraceRatio]\n");
			System.exit(-1);
		} else {
			if (args[0].equalsIgnoreCase("eventgenerator")) {
				EventGenerator.main(Arrays.copyOfRange(args, 1, args.length));
			}
			if (args[0].equalsIgnoreCase("eventconsumer")) {
				EventConsumer.main(Arrays.copyOfRange(args, 1, args.length));
			}
			if (args[0].equalsIgnoreCase("relationconsumer")) {
				RelationConsumer.main(Arrays.copyOfRange(args, 1, args.length));
			}
			if (args[0].equalsIgnoreCase("updateconsumer")) {
				UpdateConsumer.main(Arrays.copyOfRange(args, 1, args.length));
			}
			if (args[0].equalsIgnoreCase("graphconsumer")) {
				GraphConsumer.main(Arrays.copyOfRange(args, 1, args.length));			
			}
		}
	}

}
