package mrAlpha;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.Writable;

public class FollowsRelation implements Writable {
	private BooleanWritable follows;
	private BooleanWritable plus;

	public FollowsRelation() { 
		follows = new BooleanWritable(false);
		plus = new BooleanWritable(false);
	}
	
	public FollowsRelation(boolean f, boolean p) {
		follows = new BooleanWritable(f);
		plus = new BooleanWritable(p);
	}
	
	public void set(boolean f, boolean p) {
		follows.set(f);
		plus.set(p);
	}

	public void readFields(DataInput in) throws IOException {
		follows.readFields(in);
		plus.readFields(in);
	}

	public void write(DataOutput out) throws IOException {
		follows.write(out);
		plus.write(out);
	}
	
	public String toString() {
		if (follows.get() && plus.get())
			return "F+";
		if (!follows.get() && plus.get())
			return "NF+";
		if (follows.get() && !plus.get())
			return "F-";
		if (!follows.get() && !plus.get())
			return "NF-";
		return "";
	}
}
