package mrAlpha;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

class WorkflowRelation implements Writable {

	public enum WfRType { CAUSAL, PARALLEL, UNRELATED }

	private Text ev1, ev2;
	private WfRType type;
	
	public WorkflowRelation(String e1, String e2, WfRType t) {
		ev1 = new Text(e1);
		ev2 = new Text(e2);
		type = t;
	}

	public WorkflowRelation() {
		ev1 = new Text();
		ev2 = new Text();
		type = WfRType.CAUSAL;
	}

	public WorkflowRelation(EventPair ep, WfRType t) {
		ev1 = new Text(ep.getEvent1());
		ev2 = new Text(ep.getEvent2());
		type = t;
	}
	public void set (String e1, String e2, WfRType t) {
		ev1 = new Text(e1);
		ev2 = new Text(e2);
		type = t;
	}
	
	public WfRType getType() {
		return type;
	}
	
	public void readFields(DataInput in) throws IOException {
		ev1.readFields(in);
		ev2.readFields(in);
		IntWritable tmp = new IntWritable();
		tmp.readFields(in);
		type = WfRType.values()[tmp.get()];
	}

	public void write(DataOutput out) throws IOException {
		ev1.write(out);
		ev2.write(out);
		new IntWritable(type.ordinal()).write(out);
	}
	
	public String toString() {
		return "<" + ev1 + " " + type.toString() + " " + ev2 + ">";
	}

}
