package mrHeuristic;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.WritableComparable;

public class CNetAugmentation implements WritableComparable<CNetAugmentation> {

	private Text 				event;
	private TextArrayWritable	others;
	private CNetType			dir;
	
	public CNetAugmentation() {
		event = new Text();
		others = new TextArrayWritable();
		dir = CNetType.SUCC;
	}

	public CNetAugmentation(String ev, Text[] ot, CNetType dir) {
		event = new Text(ev);
		others = new TextArrayWritable(ot);
		this.dir = dir;
	}
	
	@Override
	public void readFields(DataInput in) throws IOException {
		event.readFields(in);
		others.readFields(in);
		IntWritable tmp = new IntWritable();
		tmp.readFields(in);
		dir = CNetType.values()[tmp.get()];
	}

	@Override
	public void write(DataOutput out) throws IOException {
		event.write(out);
		others.write(out);
		new IntWritable(dir.ordinal()).write(out);
	}

	@Override
	public int compareTo(CNetAugmentation other) {
		
		if (this.dir != other.dir) return this.dir.compareTo(other.dir);
		int c = this.event.compareTo(other.event);
		if (c != 0) return c;
		return this.others.compareTo(other.others);
	}
	
	@Override
	public String toString() {
		return "CnetAugmentation (" + event + "/" + others.toString() + "/" + dir.toString() + ")";
	}
}
