package mrHeuristic;

import java.util.HashMap;
import java.util.HashSet;

public class DependencyGraph {

	private HashMap<String, HashSet<String>> succ;
	private HashMap<String, HashSet<String>> pred;
	
	public DependencyGraph() {
		succ = new HashMap<String, HashSet<String>>();
		pred = new HashMap<String, HashSet<String>>();
	}
	
	public void addPred(String event, String p) {
		HashSet<String> predecessors = pred.get(event);
		if (predecessors == null) {
			predecessors = new HashSet<String>();
			pred.put(event, predecessors);
		}
		predecessors.add(p);
	}
	
	public void addSucc(String event, String s) {
		HashSet<String> successors = succ.get(event);
		if (successors == null) {
			successors = new HashSet<String>();
			succ.put(event, successors);
		}
		successors.add(s);
	}
	
	public HashSet<String>	getSucc(String event) {
		HashSet<String> r = succ.get(event);
		if (r == null)
			return new HashSet<String>();
		else
			return r;
	}
	
	public HashSet<String>	getPred(String event) {
		HashSet<String> r = pred.get(event);
		if (r == null)
			return new HashSet<String>();
		else
			return r;
	}
	
	public boolean isSucc(String event1, String event2) {
		HashSet<String> successors = succ.get(event1);
		if (successors != null)
			return successors.contains(event2);
		else
			return false;
	}
	
	public boolean isPred(String event1, String event2) {
		HashSet<String> predecessors = pred.get(event1);
		if (predecessors != null)
			return predecessors.contains(event2);
		else
			return false;
	}
	
	public String toString() {
		return "DG \n" + succ.toString() + "\n" + pred.toString();
	}
}
