package mrHeuristic;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

class DependencyRelation implements Writable {

	private Text ev1, ev2;
	private WfRType type;
	private FloatWritable dep;
	
	public DependencyRelation() {
		ev1 = new Text();
		ev2 = new Text();
		type = WfRType.DIRECT;
		dep = new FloatWritable(0);
	};
	
	public DependencyRelation(String ev1, String ev2, WfRType type, Float dep) {
		this.ev1 = new Text(ev1);
		this.ev2 = new Text(ev2);
		this.type = type;
		this.dep = new FloatWritable(dep);
	}

	public DependencyRelation(String ev1, String ev2, WfRType type) {
		this.ev1 = new Text(ev1);
		this.ev2 = new Text(ev2);
		this.type = type;
		this.dep = new FloatWritable(1);
	}

	public void set (String ev1, String ev2, WfRType type, Float dep) {
		this.ev1 = new Text(ev1);
		this.ev2 = new Text(ev2);
		this.type = type;
		this.dep = new FloatWritable(dep);
	}
	
	public WfRType getType() {return type;}
	public Float getDep() {return dep.get(); }
	public Text getEvent1() { return new Text(ev1); }
	public Text getEvent2() { return new Text(ev2); }
	
	public void readFields(DataInput in) throws IOException {
		ev1.readFields(in);
		ev2.readFields(in);
		IntWritable tmp = new IntWritable();
		tmp.readFields(in);
		type = WfRType.values()[tmp.get()];
		dep.readFields(in);
	}

	public void write(DataOutput out) throws IOException {
		ev1.write(out);
		ev2.write(out);
		new IntWritable(type.ordinal()).write(out);
		dep.write(out);
	}
	
	public String toString() {
		return "<" + ev1 + " " + type.toString() + " " + ev2 + " / " + dep + ">";
	}

}
