package mrHeuristic;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparable;

public class EventPair implements WritableComparable<EventPair> {
	private Text event1, event2;

	public EventPair(String ev1, String ev2) {
		event1 = new Text(ev1);
		event2 = new Text(ev2);
	}
	
	public EventPair() {
		event1 = new Text();
		event2 = new Text();
	}
	
	public EventPair(EventPair ep) {
		this.event1 = new Text(ep.event1);
		this.event2 = new Text(ep.event2);
	}

	public EventPair(Text ev1, Text ev2) {
		event1 = new Text(ev1);
		event2 = new Text(ev2);
	}

	public void set(String ev1, String ev2) {
		event1.set(ev1);
		event2.set(ev2);
	}
	
	public String getEvent1() {
		return event1.toString();
	}

	public String getEvent2() {
		return event2.toString();
	}

	public Text getEvent1Text() {
		return new Text(event1);
	}

	public Text getEvent2Text() {
		return new Text(event2);
	}

	public int compareTo(EventPair other) {
		int c = event1.toString().compareTo(other.event1.toString());
		if (c != 0) return c;
		return event2.toString().compareTo(other.event2.toString());
	}

	public int hashCode() {
		return event1.hashCode() + 163 * event2.hashCode();
	}
	
	public void readFields(DataInput in) throws IOException {
		event1.readFields(in);
		event2.readFields(in);
	}

	public void write(DataOutput out) throws IOException {
		event1.write(out);
		event2.write(out);
	}
	
	public String toString() {
		return "<" + event1.toString() + ", " + event2.toString() + ">";
	}
}
