package mrHeuristic;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.Timestamp;

import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparable;

    public class EventTimestampPair implements WritableComparable<EventTimestampPair> {

	private Text event;
	private Text timeStamp;

	public EventTimestampPair(String e, Timestamp ts) {
		event = new Text(e);
		timeStamp = new Text(ts.toString());
	}

	public EventTimestampPair() {
		event = new Text();
		timeStamp = new Text();
	}

	public EventTimestampPair(EventTimestampPair next) {
		this.event = new Text(next.event);
		this.timeStamp = new Text(next.timeStamp);
	}

	public void set(String e, Timestamp ts) {
		event.set(e);
		timeStamp.set(ts.toString());
	}
	
	public String getEvent() { return event.toString(); }
	
	public Timestamp getTimestamp() {
		return java.sql.Timestamp.valueOf(timeStamp.toString()); 
	}

	public void readFields(DataInput in) throws IOException {
		event.readFields(in);
		timeStamp.readFields(in);
	}

	public void write(DataOutput out) throws IOException {
		event.write(out);
		timeStamp.write(out);
	}
	
 	@Override
 	public int compareTo(EventTimestampPair other) {
 		int c = timeStamp.compareTo(other.timeStamp);
 		if (c != 0) return c;
 		return event.compareTo(other.event);
 	}

	public String toString() {
		return "<" + event.toString() + ", " + timeStamp.toString() + ">";
	}
}
