package mrHeuristic;

import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.Text;

public class TextArrayWritable extends ArrayWritable implements Comparable<TextArrayWritable> {
	public TextArrayWritable() {
		super(Text.class);
	}

	public TextArrayWritable(Text[] ot) {
		super(Text.class, ot);		
	}
	
	@Override
	public int compareTo(TextArrayWritable o) {
		Text[] thisArray = (Text[])this.toArray();
		Text[] otherArray = (Text[])o.toArray();
		
		if ( thisArray.length < otherArray.length) return -1;
		if ( thisArray.length > otherArray.length) return 1;
		
		for (int i = 0; i < thisArray.length; i++) {
			int c = thisArray[i].compareTo(otherArray[i]);
			if (c != 0 ) return c;
		}		
		return 0;
	}
	
	@Override
	public String toString() {
		return java.util.Arrays.asList(this.toStrings()).toString();
	}
}
