package mrHeuristic;

import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.TreeSet;

public class TwoDimTable<Key1, Key2, Content> {

	private Map<Key1, Map<Key2, Content>> map;
	private Set<Key1> dim1Elems;
	private Set<Key2> dim2Elems;
	private Content defaultElement;
	
	public TwoDimTable(Content defaultElement) {
		map = new HashMap<Key1, Map<Key2, Content>>();
		dim1Elems = new TreeSet<Key1>();
		dim2Elems = new TreeSet<Key2>();
		this.defaultElement = defaultElement;
	}
	
	public Content put(Key1 a, Key2 b, Content f) {
		dim1Elems.add(a);
		dim2Elems.add(b);
		if (map.get(a) == null)
			map.put(a, new HashMap<Key2, Content>());
		return map.get(a).put(b, f);
	}
	
	public Content get(Key1 a, Key2 b) {
		if (map.get(a) != null)
			if (map.get(a).get(b) != null)
				return map.get(a).get(b);
			else
				return defaultElement;
		else
			return defaultElement;
	}
	
	public int dim1Len() { return dim1Elems.size(); }
	public int dim2Len() { return dim2Elems.size(); }
	
	public String toString(String div) {
		String r = new String();
		for (Entry<Key1, Map<Key2, Content>> row : map.entrySet() ) {
			r += row.getKey() + div + row.getValue();
			r += "\n";
		}
		return r;		
	}
	
	public String toString() {
		return toString("  ");
	}
}
