package mrHeuristic;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

class WorkflowRelation implements Writable {

	protected Text ev1, ev2;
	protected WfRType type;
	protected BooleanWritable dir;
	
	private int fHashCode = 0;
	
	public WorkflowRelation() {
		ev1 = new Text();
		ev2 = new Text();
		type = WfRType.DIRECT;
		dir = new BooleanWritable(true);
		fHashCode = 0;
	};
	
	public WorkflowRelation(String ev1, String ev2, WfRType type, Boolean dir) {
		this.ev1 = new Text(ev1);
		this.ev2 = new Text(ev2);
		this.type = type;
		this.dir = new BooleanWritable(dir);
		fHashCode = 0;
	}

	public void set (String ev1, String ev2, WfRType type, Boolean dir) {
		this.ev1 = new Text(ev1);
		this.ev2 = new Text(ev2);
		this.type = type;
		this.dir = new BooleanWritable(dir);
		fHashCode = 0;
	}
	
	public String getEvent1() {return ev1.toString(); }
	public String getEvent2() {return ev2.toString(); }
	public WfRType getType() {return type;}
	public boolean getDir() {return dir.get(); }
	
	public void readFields(DataInput in) throws IOException {
		ev1.readFields(in);
		ev2.readFields(in);
		IntWritable tmp = new IntWritable();
		tmp.readFields(in);
		type = WfRType.values()[tmp.get()];
		dir.readFields(in);
		fHashCode = 0;
	}

	public void write(DataOutput out) throws IOException {
		ev1.write(out);
		ev2.write(out);
		new IntWritable(type.ordinal()).write(out);
		dir.write(out);
	}
	

	public String toString() {
		return "<" + ev1 + " " + type.toString() + " " + ev2 + " / " + dir + ">";
	}

	public int getfHashCode() {
		return fHashCode;
	}

	public void setfHashCode(int fHashCode) {
		this.fHashCode = fHashCode;
	}

}
