package mrHeuristic;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

class WorkflowRelationExt extends Object implements Writable {

	private Text ev1, ev2;
	private WfRType type;
	private BooleanWritable dir;
	private IntWritable count;
	
	public WorkflowRelationExt() {
		ev1 = new Text();
		ev2 = new Text();
		type = WfRType.DIRECT;
		dir = new BooleanWritable(true);
		count = new IntWritable(1);
	};
	
	public WorkflowRelationExt(String ev1, String ev2, WfRType type, Boolean dir) {
		this.ev1 = new Text(ev1);
		this.ev2 = new Text(ev2);
		this.type = type;
		this.dir = new BooleanWritable(dir);
		this.count = new IntWritable(1);
	}
	
	public WorkflowRelationExt(WorkflowRelation wfr) {
/*		this.ev1 = new Text(wfr.ev1);
		this.ev2 = new Text(wfr.ev2);
		this.type = wfr.type;
		this.dir = new BooleanWritable(wfr.dir.get());
		this.count = new IntWritable(1);		
		*/
		this.ev1 = wfr.ev1;
		this.ev2 = wfr.ev2;
		this.type = wfr.type;
		this.dir = wfr.dir;
		this.count = new IntWritable(1);		
	}

	public WorkflowRelationExt(WorkflowRelation wfr, Integer count) {
/*		this.ev1 = new Text(wfr.ev1);
		this.ev2 = new Text(wfr.ev2);
		this.type = wfr.type;
		this.dir = new BooleanWritable(wfr.dir.get());
		this.count = new IntWritable(1);		
		*/
		this.ev1 = wfr.ev1;
		this.ev2 = wfr.ev2;
		this.type = wfr.type;
		this.dir = wfr.dir;
		this.count = new IntWritable(count);		
	}

	public void incrementCount() {
		this.count = new IntWritable(this.count.get() + 1);
	}
	public WorkflowRelationExt(String ev1, String ev2, WfRType type, Boolean dir, Integer count) {
		this.ev1 = new Text(ev1);
		this.ev2 = new Text(ev2);
		this.type = type;
		this.dir = new BooleanWritable(dir);
		this.count = new IntWritable(count);
	}

	public void set (String ev1, String ev2, WfRType type, Boolean dir) {
		this.ev1 = new Text(ev1);
		this.ev2 = new Text(ev2);
		this.type = type;
		this.dir = new BooleanWritable(dir);
	}
	
	public String getEvent1() {return ev1.toString(); }
	public String getEvent2() {return ev2.toString(); }
	public WfRType getType() {return type;}
	public boolean getDir() {return dir.get(); }
	public Integer getCount() {return count.get(); }
	
	public void readFields(DataInput in) throws IOException {
		ev1.readFields(in);
		ev2.readFields(in);
		IntWritable tmp = new IntWritable();
		tmp.readFields(in);
		type = WfRType.values()[tmp.get()];
		dir.readFields(in);
		count.readFields(in);
	}

	public void write(DataOutput out) throws IOException {
		ev1.write(out);
		ev2.write(out);
		new IntWritable(type.ordinal()).write(out);
		dir.write(out);
		count.write(out);
	}
	
	public String toString() {
		return "<WFRExt" + ev1 + " " + type.toString() + " " + ev2 + " / " + dir + " / " + count + ">";
	}

}
