//
//  Binding.java
//  binding_aspj
//
//  Created by Joerg Evermann on Sun Sep 12 2004.
//  Copyright (c) 2004 __MyCompanyName__. All rights reserved.
//

package PropertyBinding;

import java.util.*;
import java.lang.reflect.*;

final class Binding {
	protected Object		srcObj;
	protected String		srcFld;
	protected Field			srcField;
	protected Object		dstObj;
	protected String		dstFld;
	protected Field			dstField;
	protected String		xfrmString;
	protected Method		xfrmMethod;
	protected Class[]		xfrmSig;
	protected String		dstString;
	protected Method		dstMethod;
	protected Class[]		dstSig;
	protected Method		changeEventMethod;
	protected Class[]		changeEventSig;
	protected Hashtable		spareTable;
	protected String		eventName;
	
	protected Binding (	 Object			srcObj,
						 String			srcFld,
						 Object			dstObj,
						 String			dstFld,
						 String			xfrmString,
						 Class[]		xfrmSig,
						 String			dstString,
						 Class[]		dstSig,
						 String			eventName ) throws Exception {
		this.srcObj		= srcObj;
		this.srcFld		= srcFld;
		this.dstObj		= dstObj;
		this.dstFld		= dstFld;
		this.xfrmString = xfrmString;
		this.xfrmSig	= xfrmSig;
		this.dstString  = dstString;
		this.dstSig		= dstSig;
		this.eventName  = eventName;
		this.spareTable = new Hashtable();
		
		if (srcFld != null)
			try { this.srcField = srcObj.getClass().getField(srcFld); }
			catch (Exception e) { this.srcFld = null; }
		else
			this.srcField = null;
		if (dstFld != null)
			try { this.dstField = dstObj.getClass().getField(dstFld); }
			catch (Exception e) { this.dstFld = null; }
		else
			this.dstField = null;
		if (dstString != null)
			try { this.dstMethod  = dstObj.getClass().getMethod(dstString, dstSig); }
			catch (Exception e) { this.dstMethod = null; }
		else
			this.dstMethod = null;
		if (xfrmString != null)
			try { this.xfrmMethod = srcObj.getClass().getMethod(xfrmString, xfrmSig); }
			catch (Exception e) { this.xfrmMethod = null; }
		else
			this.xfrmMethod = null;
		
		spareTable.put(dstObj + ":" + dstFld, this);
	}
}	
