//
//  Listener.java
//  binding_aspj
//
//  Created by Joerg Evermann on Thu Oct 14 2004.
//  Copyright (c) 2004 __MyCompanyName__. All rights reserved.
//

package PropertyBinding;

import java.util.*;

public abstract class Listener extends Thread {

	protected LinkedList	NotificationQueue;
	
	public Listener() {
		NotificationQueue = new LinkedList();
	}
	
	// this removes from the notification queue all
	// those notifications that go to an object and field
	// like the one specified
	private final Event NetChange(String fld) {
		Event   netEvent = new Event(fld, null, null);
		boolean beginning = false;
		Log.write(this, "NetChange called for "+fld+" with queue size "+NotificationQueue.size());
		for (int i = 0; i < NotificationQueue.size(); i++) {
			Event e = (Event)NotificationQueue.get(i);
			if ( e.field == fld ) {
				if (!beginning) {
					// if we're beginning this, we need to take care of noting
					// the oldest value
					netEvent.oldval = e.oldval;
					netEvent.newval = e.newval;
					beginning = true;
				} else {
					// after than we keep track of only the new value
					netEvent.newval = e.newval;
				}
				NotificationQueue.remove(i);
			}
		}
		return netEvent;
	}
	
	protected abstract void HandleEvent(Event e);
	
	public final void run() {
		Event e;
		try {
			while (true) {
				e = null;
				// synchronize for queue access
				synchronized(this) {
					// pick the first
					if (NotificationQueue.size() > 0) {
						// get the first event in the queue
						e = (Event)NotificationQueue.getFirst();
						// remove all following ones for the 
						// same object and field from the queue
						// (net effect notification only)
						// NetChange will remove all events for the
						// specified field from the queue,
						// including the first one.
						e = NetChange(e.field);
					} else {
						// if there isn't an event in there, sleep for a while
						// to keep the resources down
//						sleep(50);
					}
				}
				// we're done with queue acccess, so done with the 
				// synch block
				if (e != null) {
					// if we did get an event, set the
					// value of the field in this object
					this.getClass().getField(e.field).set(this, e.newval);
					// and then pass the event on to
					// the user overridden function to handle
					HandleEvent(e);
					// let's sleep some random time here
					// to simulate different types of objects
					// doing different types of things
					Random  myRand = new Random();
					sleep(myRand.nextInt(100));
				}
			}
		} catch (Exception ex) {
			ex.printStackTrace();
		}
	}
	
}
