//
//  PropertyBinding.java
//  binding_aspj
//
//  Created by Joerg Evermann on Sun Sep 12 2004.
//  Copyright (c) 2004 __MyCompanyName__. All rights reserved.
//

package PropertyBinding;

import java.util.*;
import java.lang.reflect.*;
import java.sql.*;

/* Aspects that implements
Property Binding
*/
public aspect PropBinding {

	// When we first use this aspect, we'll initialize
	// the hashtable for storing the bound properties, the
	// hashtable for the current net values 
	// the hashtable for the last values set by the object
	// and some stuff for database logging.
	// These are all class variables, they are used by 
	// all instances of the aspect
	private static Hashtable			Mappings= new Hashtable();
	private static Connection			DBConn;	
	private static PreparedStatement	DBStmt;
	
	// this is the class initializer
	static {
		try {
			// try to set up database connection
			// for logging.
			Class.forName("org.postgresql.Driver");
			DBConn = DriverManager.getConnection("jdbc:postgresql://localhost/joerg", "joerg", "");
			DBStmt = DBConn.prepareStatement("insert into interaction values (?, ?, ?, ?);");		
		} catch (Exception ex) {
			ex.printStackTrace();
		}
	}
	
	class ChangeEvent {
		public Binding		b;
		public Object		oldval, newval;
		
		public ChangeEvent (Binding b, Object oldval, Object newval) {
			this.b = b; this.oldval = oldval; this.newval = newval;
		}
	}
		
	// PropagateUpdate will handle the propagation of the new values
	// calling of transformation methods
	private void PropagateUpdate(ChangeEvent e) {
		boolean same;
		try{
			// the new value for the destination field is the same as the new
			// value for the source field
			Object  newDstVal = e.newval;
			// the old value for the destination field is the current value of
			// that field, just get it from the destination object
			Object  oldDstVal = e.b.dstField.get(e.b.dstObj);
			// transform the new value if required
			// by calling the transformation method on the source object.
			if ( e.b.xfrmMethod != null )
				newDstVal = e.b.xfrmMethod.invoke(e.b.srcObj, new Object[] {e.newval});
			// try to figure out whether there was a change in the destination value
			// we do this for the destination value, as the transformation method
			// might not yield a change in the destination, even though there was
			// one for the source field. I.e. it might be a many to one mapping of values
			if ( (newDstVal == null) && (oldDstVal == null) ) same = true;
			else if (newDstVal == null) same = false;
			else if (oldDstVal == null) same = false;
			else same = ((Comparable)oldDstVal).compareTo((Comparable)newDstVal) == 0;
			
			if ( !same ) {
				// Log the change in the database
				DBStmt.setString(1, String.valueOf(System.currentTimeMillis()) );
				DBStmt.setString(2, e.b.srcObj.toString() );
				DBStmt.setString(3, e.b.dstObj.toString() );
				DBStmt.setString(4, e.b.eventName );
				DBStmt.executeUpdate();
				// Log the change in the error output stream
				Log.write(this, e.b.srcObj+" :: "+e.b.srcFld+" ("+e.oldval+", "+e.newval+")  --> "+e.b.dstObj+" :: "+e.b.dstFld+"  ("+oldDstVal+", "+newDstVal+") :  "+e.b.eventName);
				// then set the new property value, 
				// first on the source object
				e.b.srcField.set(e.b.srcObj, e.newval);

				// We don't set the value on the destination object
				// that is the responsibility of the object/thread
				// when it sees the notification in its message queue.
				// at that point in time, it can perform net-change
				// calculations and set the proper value.
					// e.b.dstField.set(e.b.dstObj, newDstVal);
				// add the request for notification of the destination object 
				// into the queue of the the destination object
				synchronized(e.b.dstObj) {
					// this is synchronized as we're using the NotificationQueue of the 
					// destination object
					((Listener)e.b.dstObj).NotificationQueue.addLast( new Event(e.b.dstFld, oldDstVal, newDstVal) );
				}
				// and propagate all changes
				// Propagate the updated changes.
				// find other bindings
				Hashtable h = (Hashtable)Mappings.get(e.b.dstObj + ":" + e.b.dstFld);
				if (h != null) {
					// if there is a mapping from that destination
					Object  oldval = oldDstVal;
					Object  newval = newDstVal;
					
					for (Enumeration ee = h.elements();  ee.hasMoreElements(); ) {
						PropagateUpdate(new ChangeEvent( (Binding)ee.nextElement(), oldval, newval));
					}
				}				
			}
		} catch (Exception ex) {
			Log.write(this, "Exception in HandleBinding: " + ex.getMessage());
			ex.printStackTrace();
		}
	}
	
	static public boolean addBindings ( BoundProperties b ) {
		boolean ret = true;
		try {
			for (int cnt = 0; cnt < b.bindings.size() && ret; cnt++ ) {
				ret = ret && addBindingsSimple( (Binding)b.bindings.get(cnt) );
			}
			return ret;
		} catch (Exception e) {
			Log.write(null, "addBindings: Exception" + e.getMessage() );
			e.printStackTrace();
			return false;
		}
	}
	
	// This function is private, clients should call
	// addBindings
	static private boolean addBindingsSimple ( Binding b ) throws BindingException {
		// we synchronize on the class object, because
		// we're manipulating class scope variables (the binding hashtable)
		// This way, we can allow adding of bindings
		// while the system is running.
		synchronized (PropBinding.class) {
			try {
				// Some basic sanity checks
				if ( b.srcField != null && b.dstField != null && b.srcObj != null && b.dstObj != null)
					// source and target fields exist
					//  if ( Arrays.asList(b.dstObj.getClass().getInterfaces()).contains(PropBinding.Listener.class) || b.dstMethod != null )
					// If the destination object implements the StateMachine interface it doesn't need a
					// destination method.
					if ( ( b.dstMethod != null && 
						   b.dstSig[1] == b.dstField.getType() && 
						   b.dstSig[2] == b.dstField.getType() &&
						   b.dstSig[0] == String.class ) ||
						 b.dstMethod == null )
						// if the destination method is set, it must accept the proper types
						if ( ( b.srcField.getType() == b.dstField.getType()) ||
							 ( b.srcField.getType() != b.dstField.getType() && b.xfrmMethod != null) )
							// if the source and destination types are not the same, a xfrmMethod must be provided
							if ( Arrays.asList(b.dstField.getType().getInterfaces()).contains(Comparable.class) &&
								 Arrays.asList(b.srcField.getType().getInterfaces()).contains(Comparable.class) )
								// The source and destination types must be comparable
								if (( b.xfrmMethod == null ) ||
									( b.xfrmMethod != null && 
									  b.xfrmSig[0] == b.srcField.getType() &&
									  b.xfrmMethod.getReturnType() == b.dstField.getType()) ) {
									// if the xfrmMethod is set, it must take a parameter of the same type
									// as the source field and return a value of the same type as the
									// destination field.
									Hashtable h = (Hashtable)Mappings.get(b.srcObj + ":" + b.srcFld);
									if (h == null) {
										Mappings.put(b.srcObj + ":" + b.srcFld, b.spareTable);
									} else {
										h.put(b.dstObj + ":" + b.dstFld, b);
									}
									return true;
								} else throw new BindingException ("Transform method error");
							else throw new BindingException ("Types not comparable");
						else throw new BindingException("Types not identical and no transform method provided");
					else throw new BindingException("Destination notification method error");
				//  else throw new BindingException("Object does not implement PropBinding.Listener and no destination notification method provided");
				else throw new BindingException("Source and Destination Fields don't exist");
			} catch (Exception e) {
				Log.write(null, "Exception in addBindingsSimple: " + e.getMessage());
				e.printStackTrace();
				return false;
			}			
		}
	}
		
	// This pointcut looks for changes in fields of
	// objects
	pointcut FieldChange(): set ( public Object+ * ) && ! within( PropertyBinding.* );
 	// When a field change is detected we run this
	// Advice. It figures out the oldvalue and the new
	// value and then calls the appropriate method.
	//
	// We need to synchronize this on the aspect class
	// as we're manipulating shared variables (the bindings hashtable)
	void around () : FieldChange() {
		synchronized(PropBinding.class) {
			try {
				// determine the source field and object
				Object  srcObj		= thisJoinPoint.getTarget();
				Class   srcCls		= srcObj.getClass();
				String  srcFld		= thisJoinPoint.getStaticPart().getSignature().getName();
				Field   srcField	= srcCls.getField(srcFld);
				
				// find out whether there are any bindings for that
				// object and field
				Hashtable h = (Hashtable)Mappings.get(srcObj + ":" + srcFld);
				// if there are
				if (h != null) {
					// if there is a mapping from that source
					Object  oldval = srcField.get(srcObj);
					Object  newval = thisJoinPoint.getArgs()[0];				
					Log.write(this, "FieldChange ==> "+srcFld+"/"+srcObj+" ==> Oldval = "+oldval+" Newval = " + newval);
					// Find all bindings so that we can propate changes
					for (   Enumeration ee = h.elements();  
							ee.hasMoreElements(); 
							PropagateUpdate(new ChangeEvent( (Binding)ee.nextElement(), oldval, newval))
						);
					// in contrast to the single threaded model, we have a distributed notification
					// queue. Each object/thread has its own queue and must do its own net-change 
					// computation
				}
				// allow the object to set the value
				proceed();
			} catch (Exception e) {
				Log.write(this, "Exception in FieldChange: " + e.getMessage()); 
				e.printStackTrace();
			}
			
		}
	}

}
