<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:uml="http://schema.omg.org/spec/UML/2.0" xmlns:xmi="http://schema.omg.org/spec/XMI/2.1" version="1.0">

<!-- This works with MagicDraw 11.5 -->
<!-- MagicDraw 12 uses a different XMI format -->

	<xsl:output method="text"/>

<!-- Override the built-in template that outputs all text -->
	<xsl:template match="text()|@*">
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="*" priority="-1">
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="ownedMember[@xmi:type='uml:Class']">
		<!-- Find out stereotype ID's and collect them in variables -->
		<xsl:variable name="profilestereotypeID" select="//ownedMember[@xmi:type='uml:Profile' and @name='aspectJ']/@xmi:id"/>
		<xsl:variable name="aspectstereotypeID" select="//ownedMember[@xmi:id=$profilestereotypeID]/ownedStereotype[@name='Aspect']/@xmi:id"/>
		<xsl:variable name="isprivilegedfeatureID" select="//ownedMember[@xmi:id=$profilestereotypeID]/ownedStereotype[@name='Aspect']/ownedAttribute[@name='isPrivileged']/@xmi:id"/>
		<xsl:variable name="pertypefeatureID" select="//ownedMember[@xmi:id=$profilestereotypeID]/ownedStereotype[@name='Aspect']/ownedAttribute[@name='perType']/@xmi:id"/>
		<xsl:variable name="perpointcutID" select="//ownedMember[@xmi:id=$profilestereotypeID]/ownedStereotype[@name='Aspect']/ownedAttribute[@name='perPointCut']/@xmi:id"/>
		<xsl:variable name="declaredparentsfeatureID" select="//ownedMember[@xmi:id=$profilestereotypeID]/ownedStereotype[@name='Aspect']/ownedAttribute[@name='declaredParents']/@xmi:id"/>
		<xsl:variable name="declaredimplementsfeatureID" select="//ownedMember[@xmi:id=$profilestereotypeID]/ownedStereotype[@name='Aspect']/ownedAttribute[@name='declaredImplements']/@xmi:id"/>
		<xsl:variable name="advicestereotypeID" select="//ownedMember[@xmi:id=$profilestereotypeID]/ownedStereotype[@name='Advice']/@xmi:id"/>
		<xsl:variable name="crosscuttingconcernstereotypeID" select="//ownedMember[@xmi:id=$profilestereotypeID]/ownedStereotype[@name='CrossCuttingConcern']/@xmi:id"/>
		<xsl:variable name="staticcrosscuttingfeatureID" select="//ownedMember[@xmi:id=$profilestereotypeID]/ownedStereotype[@name='StaticCrossCuttingFeature']/@xmi:id"/>
		<xsl:variable name="advicepointcutfeatureID" select="//ownedMember[@xmi:id=$profilestereotypeID]/ownedStereotype[@xmi:id=$advicestereotypeID]/ownedAttribute[@name='pointCut']/@xmi:id"/>
		<xsl:variable name="adviceexecutionfeatureID" select="//ownedMember[@xmi:id=$profilestereotypeID]/ownedStereotype[@xmi:id=$advicestereotypeID]/ownedAttribute[@name='adviceExecution']/@xmi:id"/>
		<xsl:variable name="selectedpointcutfeatureID" select="//ownedMember[@xmi:id=$profilestereotypeID]/ownedStereotype[@name='PointCutPointCut']/ownedAttribute[@name='selectedPointCut']/@xmi:id"/>
		<xsl:variable name="composeefeatureID" select="//ownedMember[@xmi:id=$profilestereotypeID]/ownedStereotype[@name='CompositePointCut']/ownedAttribute[@name='composee']/@xmi:id"/>

		<xsl:if test="xmi:Extension/modelExtension/appliedStereotypeInstance/classifier[@xmi:idref=$aspectstereotypeID]">
		<!-- the stereotype is an aspectJ aspect -->
			<xsl:variable name="thisID" select="@xmi:id"/>
			<xsl:variable name="aspectstereotypeinstance" select="xmi:Extension/modelExtension/appliedStereotypeInstance[classifier[@xmi:idref=$aspectstereotypeID]]"/>

			<xsl:if test="//ownedMember[xmi:Extension/modelExtension/appliedStereotypeInstance/classifier[@xmi:idref=$crosscuttingconcernstereotypeID] and ownedMember[@xmi:id=$thisID]]">
package <xsl:value-of select="../@name"/>;
			</xsl:if>

			<xsl:if test="$aspectstereotypeinstance/slot[@definingFeature=$isprivilegedfeatureID]/value/@value = 'true'">privileged </xsl:if>
aspect <xsl:value-of select="@name"/> {

			<xsl:for-each select="$aspectstereotypeinstance/slot[@definingFeature=$declaredparentsfeatureID]/value">
				<xsl:variable name="elementID" select="@element"/>
				declare parents:
				<xsl:call-template name="buildName">
					<xsl:with-param name="element" select="//generalization[@xmi:id=$elementID]/.."/>
					<xsl:with-param name="name" select="//generalization[@xmi:id=$elementID]/../@name"/>
				</xsl:call-template> extends
				<xsl:variable name="generalID" select="//generalization[@xmi:id=$elementID]/@general"/>
				<xsl:call-template name="buildName">
					<xsl:with-param name="element" select="//ownedMember[@xmi:id=$generalID]"/>
					<xsl:with-param name="name" select="//ownedMember[@xmi:id=$generalID]/@name"/>
				</xsl:call-template>;
			</xsl:for-each>

			<xsl:for-each select="$aspectstereotypeinstance/slot[@definingFeature=$declaredimplementsfeatureID]/value">
				<xsl:variable name="elementID" select="@element"/>
				declare parents:
				<xsl:call-template name="buildName">
					<xsl:with-param name="element" select="//interfaceRealization[@xmi:id=$elementID]/.."/>
					<xsl:with-param name="name" select="//interfaceRealization[@xmi:id=$elementID]/../@name"/>
				</xsl:call-template> implements
				<xsl:variable name="supplierID" select="//interfaceRealization[@xmi:id=$elementID]/supplier/@xmi:idref"/>
				<xsl:call-template name="buildName">
					<xsl:with-param name="element" select="//ownedMember[@xmi:id=$supplierID]"/>
					<xsl:with-param name="name" select="//ownedMember[@xmi:id=$supplierID]/@name"/>
				</xsl:call-template>;
			</xsl:for-each>

			<xsl:for-each select="ownedAttribute[@xmi:type='uml:Property' and xmi:Extension/modelExtension/appliedStereotypeInstance]">
				<xsl:variable name="pointcutstereotypeID" select="xmi:Extension/modelExtension/appliedStereotypeInstance/classifier/@xmi:idref"/>
				<!-- found a stereotyped attribute -->
				<xsl:if test="//ownedMember[@xmi:id=$profilestereotypeID]/ownedStereotype[@xmi:id=$pointcutstereotypeID and ownedAttribute/@name='base_StructuralFeature']">
					<xsl:variable name="pointcuttype" select="//ownedMember[@xmi:id=$profilestereotypeID]/ownedStereotype[@xmi:id=$pointcutstereotypeID and ownedAttribute/@name='base_StructuralFeature']/@name"/>
					<xsl:variable name="pointcutinstance" select="xmi:Extension/modelExtension/appliedStereotypeInstance[classifier/@xmi:idref=$pointcutstereotypeID]"/>
					<!-- the stereotype is an aspectJ stereotype on a structural feature, this must be a pointcut -->
   pointcut <xsl:value-of select="@name"/> (
   					<xsl:call-template name="processPointCutContext">
						<xsl:with-param name="pointcuttype" select="$pointcuttype"/>
						<xsl:with-param name="pointcutinstance" select="$pointcutinstance"/>
					</xsl:call-template>):
					<xsl:call-template name="processPointCut">
						<xsl:with-param name="pointcuttype" select="$pointcuttype"/>
						<xsl:with-param name="pointcutinstance" select="$pointcutinstance"/>
					</xsl:call-template>
					;
				</xsl:if>
			</xsl:for-each>

			<xsl:for-each select="ownedOperation[xmi:Extension/modelExtension/appliedStereotypeInstance/classifier[@xmi:idref=$advicestereotypeID]]">
				<xsl:variable name="theadviceexecution" select="xmi:Extension/modelExtension/appliedStereotypeInstance[classifier[@xmi:idref=$advicestereotypeID]]/slot[@definingFeature=$adviceexecutionfeatureID]/value/@instance"/>
				<xsl:variable name="adviceexecutiontype" select="//ownedMember[@xmi:id=$profilestereotypeID]/ownedMember[@name='AdviceExecutionType']/ownedLiteral[@xmi:id=$theadviceexecution]/@name"/>
				<xsl:choose>
				<xsl:when test="$adviceexecutiontype='AroundAdvice'">
					<xsl:if test="ownedParameter[@direction='return']">
							<xsl:choose>
								<xsl:when test="count(ownedParameter[@direction='return']/type)=1">
									<xsl:value-of select="translate(normalize-space(translate(translate(ownedParameter[@direction='return']/type/xmi:Extension/referenceExtension/@referentPath,' ','_'),':',' ')),' ','.')"/>
								</xsl:when>
								<xsl:when test="count(ownedParameter[@direction='return']/@type)=1">
									<xsl:call-template name="writeType"><xsl:with-param name="type" select="ownedParameter[@direction='return']/@type"/></xsl:call-template>
								</xsl:when>
							</xsl:choose>
							<xsl:text> </xsl:text>
					</xsl:if>
					around(
					</xsl:when>
					<xsl:when test="$adviceexecutiontype='AfterAdvice'">after(</xsl:when>
					<xsl:when test="$adviceexecutiontype='BeforeAdvice'">before(</xsl:when>
				</xsl:choose>
				<xsl:for-each select="ownedParameter[@direction='in']">
					<xsl:choose>
						<xsl:when test="count(type)=1">
							<xsl:value-of select="translate(normalize-space(translate(translate(type/xmi:Extension/referenceExtension/@referentPath,' ','_'),':',' ')),' ','.')"/>
						</xsl:when>
						<xsl:when test="count(@type)=1">
							<xsl:call-template name="writeType"><xsl:with-param name="type" select="@type"/></xsl:call-template>
						</xsl:when>
					</xsl:choose>
					<xsl:text> </xsl:text><xsl:value-of select="@name"/>
					<xsl:if test="position() &lt; count(../ownedParameter[@direction='in'])"><xsl:text>, </xsl:text></xsl:if>
				</xsl:for-each>	)
				<xsl:if test="$adviceexecutiontype='AfterAdvice'">
					<xsl:if test="ownedParameter[@direction='return']">
						returning ( 
							<xsl:choose>
								<xsl:when test="count(ownedParameter[@direction='return']/type)=1">
									<xsl:value-of select="translate(normalize-space(translate(translate(ownedParameter[@direction='return']/type/xmi:Extension/referenceExtension/@referentPath,' ','_'),':',' ')),' ','.')"/>
								</xsl:when>
								<xsl:when test="count(ownedParameter[@direction='return']/@type)=1">
									<xsl:call-template name="writeType"><xsl:with-param name="type" select="ownedParameter[@direction='return']/@type"/></xsl:call-template>
								</xsl:when>
							</xsl:choose>
							<xsl:text> </xsl:text>
							<xsl:choose>
								<xsl:when test="count(ownedParameter[@direction='return']/@name)">
									<xsl:value-of select="ownedParameter[@direction='return']/@name"/>
								</xsl:when>
								<xsl:otherwise>
									result
								</xsl:otherwise>
							</xsl:choose>
							)
					</xsl:if>
					<xsl:if test="raisedException">
						throwing
						<xsl:for-each select="raisedException">
							<xsl:variable name="exceptionID" select="@xmi:idref"/>
							<xsl:call-template name="buildName">
								<xsl:with-param name="element" select="//ownedMember[@xmi:id=$exceptionID]"/>
								<xsl:with-param name="name" select="//ownedMember[@xmi:id=$exceptionID]/@name"/>
							</xsl:call-template>
							<xsl:if test="position() &lt; count(../raisedException)"><xsl:text>, </xsl:text></xsl:if>
						</xsl:for-each>
					</xsl:if>
				</xsl:if>
				<xsl:text> : </xsl:text>
				<xsl:variable name="thepointcut" select="xmi:Extension/modelExtension/appliedStereotypeInstance[classifier[@xmi:idref=$advicestereotypeID]]/slot[@definingFeature=$advicepointcutfeatureID]/value/@element"/>
				<xsl:value-of select="../ownedAttribute[@xmi:id=$thepointcut]/@name"/>(
				<xsl:for-each select="ownedParameter[@direction='in']">
					<xsl:value-of select="@name"/>
					<xsl:if test="position() &lt; count(../ownedParameter[@direction='in'])"><xsl:text>, </xsl:text></xsl:if>
				</xsl:for-each>	)
				<xsl:text> </xsl:text>{}
			</xsl:for-each>

			<xsl:for-each select="ownedAttribute[xmi:Extension/modelExtension/appliedStereotypeInstance/classifier/@xmi:idref=$staticcrosscuttingfeatureID]">
				<xsl:variable name="attribute" select="."/>
				<xsl:for-each select="xmi:Extension/modelExtension/appliedStereotypeInstance[classifier/@xmi:idref=$staticcrosscuttingfeatureID]/slot/value">
					<xsl:variable name="elementID" select="@element"/>
<xsl:value-of select="$attribute/@visibility"/><xsl:text> </xsl:text>
					<xsl:choose>
						<xsl:when test="count($attribute/type)=1">
							<xsl:value-of select="translate(normalize-space(translate(translate($attribute/type/xmi:Extension/referenceExtension/@referentPath,' ','_'),':',' ')),' ','.')"/>
						</xsl:when>
						<xsl:when test="count($attribute/@type)=1">
							<xsl:call-template name="writeType"><xsl:with-param name="type" select="$attribute/@type"/></xsl:call-template>
						</xsl:when>
					</xsl:choose>
					<xsl:text> </xsl:text>
   					<xsl:call-template name="buildName">
						<xsl:with-param name="element" select="//ownedMember[@xmi:id=$elementID]"/>
						<xsl:with-param name="name" select="concat(//ownedMember[@xmi:id=$elementID]/@name, '.', $attribute/@name)"/>
					</xsl:call-template>;
				</xsl:for-each>
			</xsl:for-each>

			<xsl:for-each select="ownedOperation[xmi:Extension/modelExtension/appliedStereotypeInstance/classifier/@xmi:idref=$staticcrosscuttingfeatureID]">
				<xsl:variable name="operation" select="."/>
				<xsl:for-each select="xmi:Extension/modelExtension/appliedStereotypeInstance[classifier/@xmi:idref=$staticcrosscuttingfeatureID]/slot/value">
					<xsl:variable name="elementID" select="@element"/>
<xsl:value-of select="$operation/@visibility"/><xsl:text> </xsl:text>
					<xsl:choose>
						<xsl:when test="count($operation/ownedParameter[@direction='return'])=1">
							<xsl:choose>
								<xsl:when test="count($operation/ownedParameter[@direction='return']/type)=1">
									<xsl:value-of select="translate(normalize-space(translate(translate($operation/ownedParameter[@direction='return']/type/xmi:Extension/referenceExtension/@referentPath,' ','_'),':',' ')),' ','.')"/>
								</xsl:when>
								<xsl:when test="count($operation/ownedParameter[@direction='return']/@type)=1">
									<xsl:call-template name="writeType"><xsl:with-param name="type" select="$operation/ownedParameter[@direction='return']/@type"/></xsl:call-template>
								</xsl:when>
							</xsl:choose>
							<xsl:text> </xsl:text>
						</xsl:when>
						<xsl:otherwise>
							<xsl:text>void </xsl:text>
						</xsl:otherwise>
					</xsl:choose>
   					<xsl:call-template name="buildName">
						<xsl:with-param name="element" select="//ownedMember[@xmi:id=$elementID]"/>
						<xsl:with-param name="name" select="concat(//ownedMember[@xmi:id=$elementID]/@name, '.', $operation/@name)"/>
					</xsl:call-template> (
					<xsl:for-each select="$operation/ownedParameter[@direction='in']">
						<xsl:choose>
							<xsl:when test="count(type)=1">
								<xsl:value-of select="translate(normalize-space(translate(translate(type/xmi:Extension/referenceExtension/@referentPath,' ','_'),':',' ')),' ','.')"/>
							</xsl:when>
							<xsl:when test="count(@type)=1">
								<xsl:call-template name="writeType"><xsl:with-param name="type" select="@type"/></xsl:call-template>
							</xsl:when>
						</xsl:choose>
						<xsl:text> </xsl:text><xsl:value-of select="@name"/>
   						<xsl:if test="position() &lt; count(../ownedParameter[@direction='in'])"><xsl:text>, </xsl:text></xsl:if>
					</xsl:for-each>	) {};
				</xsl:for-each>
			</xsl:for-each>
}
		</xsl:if>
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template name="buildName">
		<xsl:param name="element"/>
		<xsl:param name="name"/>
		<xsl:choose>
			<xsl:when test="$element/../@xmi:type='uml:Package' or $element/../@xmi:type='uml:Class'">
				<xsl:call-template name="buildName">
					<xsl:with-param name="element" select="$element/.."/>
					<xsl:with-param name="name" select="concat($element/../@name,'.',$name)"/>
					</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
<xsl:value-of select="$name"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="writeType">
		<xsl:param name="type"/>
		<xsl:variable name="thetype" select="//ownedMember[@xmi:id=$type]"/>
		<xsl:call-template name="buildName">
			<xsl:with-param name="element" select="$thetype"/>
			<xsl:with-param name="name" select="$thetype/@name"/>
		</xsl:call-template>
	</xsl:template>

	<xsl:template name="writeOperation">
		<xsl:param name="operation"/>
		<xsl:variable name="theoperation" select="//ownedOperation[@xmi:id=$operation]"/>
		<xsl:value-of select="$theoperation/@visibility"/><xsl:text> </xsl:text>
		<xsl:choose>
			<xsl:when test="count($theoperation/ownedParameter[@direction='return'])=1">
				<xsl:choose>
					<xsl:when test="count($theoperation/ownedParameter[@direction='return']/type)=1">
						<xsl:value-of select="translate(normalize-space(translate(translate($theoperation/ownedParameter[@direction='return']/type/xmi:Extension/referenceExtension/@referentPath,' ','_'),':',' ')),' ','.')"/>
					</xsl:when>
					<xsl:when test="count($theoperation/ownedParameter[@direction='return']/@type)=1">
						<xsl:call-template name="writeType"><xsl:with-param name="type" select="$theoperation/ownedParameter[@direction='return']/@type"/></xsl:call-template>
					</xsl:when>
				</xsl:choose>
				<xsl:text> </xsl:text>
			</xsl:when>
			<xsl:otherwise>
				<xsl:text>void </xsl:text>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:call-template name="buildName">
			<xsl:with-param name="element" select="$theoperation"/>
			<xsl:with-param name="name" select="$theoperation/@name"/>
		</xsl:call-template> (
		<xsl:for-each select="$theoperation/ownedParameter[@direction='in']">
			<xsl:choose>
				<xsl:when test="count(@type)=1">
					<xsl:call-template name="writeType"><xsl:with-param name="type" select="@type"/></xsl:call-template>
				</xsl:when>
				<xsl:when test="count(type)=1">
					<xsl:value-of select="translate(normalize-space(translate(translate(type/xmi:Extension/referenceExtension/@referentPath,' ','_'),':',' ')),' ','.')"/>
				</xsl:when>
			</xsl:choose>
  <!--<xsl:text> </xsl:text><xsl:value-of select="@name"/> -->
			<xsl:if test="position() &lt; count(../ownedParameter[@direction='in'])"><xsl:text>, </xsl:text></xsl:if>
		</xsl:for-each>	)
	</xsl:template>

	<xsl:template name="writeConstructor">
		<xsl:param name="operation"/>
		<xsl:variable name="theoperation" select="//ownedOperation[@xmi:id=$operation]"/>
		<xsl:value-of select="$theoperation/@visibility"/><xsl:text> </xsl:text>
		<xsl:call-template name="buildName">
			<xsl:with-param name="element" select="$theoperation"/>
			<xsl:with-param name="name" select="$theoperation/@name"/>
		</xsl:call-template> (
		<xsl:for-each select="$theoperation/ownedParameter[@direction='in']">
			<xsl:choose>
				<xsl:when test="count(@type)=1">
					<xsl:call-template name="writeType"><xsl:with-param name="type" select="@type"/></xsl:call-template>
				</xsl:when>
				<xsl:when test="count(type)=1">
					<xsl:value-of select="translate(normalize-space(translate(translate(type/xmi:Extension/referenceExtension/@referentPath,' ','_'),':',' ')),' ','.')"/>
				</xsl:when>
			</xsl:choose>
  <!--<xsl:text> </xsl:text><xsl:value-of select="@name"/> -->
			<xsl:if test="position() &lt; count(../ownedParameter[@direction='in'])"><xsl:text>, </xsl:text></xsl:if>
		</xsl:for-each>	)
	</xsl:template>

	<xsl:template name="writeField">
		<xsl:param name="field"/>
		<xsl:variable name="attribute" select="//ownedAttribute[@xmi:id=$field]"/>
		<xsl:value-of select="$attribute/@visibility"/><xsl:text> </xsl:text>	
		<xsl:choose>
			<xsl:when test="count($attribute/@type)=1">
				<xsl:call-template name="writeType"><xsl:with-param name="type" select="$attribute/@type"/></xsl:call-template>
			</xsl:when>
			<xsl:when test="count($attribute/type)=1">
		<xsl:value-of select="translate(normalize-space(translate(translate($attribute/type/xmi:Extension/referenceExtension/@referentPath,' ','_'),':',' ')),' ','.')"/>
			</xsl:when>
		</xsl:choose>
		<xsl:text> </xsl:text>
		<xsl:call-template name="buildName">
			<xsl:with-param name="element" select="$attribute"/>
			<xsl:with-param name="name" select="$attribute/@name"/>
		</xsl:call-template>
	</xsl:template>

	<xsl:template name="writePointCut">
		<xsl:param name="pointcut"/>
		<xsl:variable name="thepointcut" select="//ownedAttribute[@xmi:id=$pointcut]"/>
		<xsl:variable name="profilestereotypeID" select="//ownedMember[@xmi:type='uml:Profile' and @name='aspectJ']/@xmi:id"/>
		<xsl:variable name="pointcutstereotypeID" select="$thepointcut/xmi:Extension/modelExtension/appliedStereotypeInstance/classifier/@xmi:idref"/>
		<xsl:variable name="pointcuttype" select="//ownedMember[@xmi:id=$profilestereotypeID]/ownedStereotype[@xmi:id=$pointcutstereotypeID and ownedAttribute/@name='base_StructuralFeature']/@name"/>
		<xsl:variable name="pointcutinstance" select="$thepointcut/xmi:Extension/modelExtension/appliedStereotypeInstance[classifier/@xmi:idref=$pointcutstereotypeID]"/>
		
		<xsl:call-template name="processPointCut">
			<xsl:with-param name="pointcuttype" select="$pointcuttype"/>
			<xsl:with-param name="pointcutinstance" select="$pointcutinstance"/>
		</xsl:call-template>
	</xsl:template>


	<xsl:template name="processPointCut">
		<xsl:param name="pointcuttype"/>
		<xsl:param name="pointcutinstance"/>
		<xsl:variable name="profilestereotypeID" select="//ownedMember[@xmi:type='uml:Profile' and @name='aspectJ']/@xmi:id"/>
		<xsl:variable name="operationfeatureID" select="//ownedMember[@xmi:id=$profilestereotypeID]/ownedStereotype[@name='OperationPointCut']/ownedAttribute[@name='operation']/@xmi:id"/>
		<xsl:variable name="typefeatureID" select="//ownedMember[@xmi:id=$profilestereotypeID]/ownedStereotype[@name='TypePointCut']/ownedAttribute[@name='type']/@xmi:id"/>
		<xsl:variable name="argnamesfeatureID" select="//ownedMember[@xmi:id=$profilestereotypeID]/ownedStereotype[@name='ContextExposingPointCut']/ownedAttribute[@name='argNames']/@xmi:id"/>
		<xsl:variable name="fieldfeatureID" select="//ownedMember[@xmi:id=$profilestereotypeID]/ownedStereotype[@name='PropertyPointCut']/ownedAttribute[@name='field']/@xmi:id"/>
		<xsl:variable name="selectedpointcutfeatureID" select="//ownedMember[@xmi:id=$profilestereotypeID]/ownedStereotype[@name='PointCutPointCut']/ownedAttribute[@name='selectedPointCut']/@xmi:id"/>
		<xsl:variable name="composeefeatureID" select="//ownedMember[@xmi:id=$profilestereotypeID]/ownedStereotype[@name='CompositePointCut']/ownedAttribute[@name='composee']/@xmi:id"/>
		<xsl:variable name="compositiontypefeatureID" select="//ownedMember[@xmi:id=$profilestereotypeID]/ownedStereotype[@name='CompositePointCut']/ownedAttribute[@name='compositionType']/@xmi:id"/>
		<xsl:choose>
		<xsl:when test="$pointcuttype='CallPointCut'">(
			<xsl:for-each select="$pointcutinstance/slot[@definingFeature=$operationfeatureID]/value">
				call(<xsl:call-template name="writeOperation"><xsl:with-param name="operation" select="@element"/></xsl:call-template>)
				<xsl:if test="position() &lt; count(../value)"><xsl:text> || </xsl:text></xsl:if>
			</xsl:for-each>)
		</xsl:when>
		<xsl:when test="$pointcuttype='ExecutionPointCut'">(
			<xsl:for-each select="$pointcutinstance/slot[@definingFeature=$operationfeatureID]/value">
				execution(<xsl:call-template name="writeOperation"><xsl:with-param name="operation" select="@element"/></xsl:call-template>)
				<xsl:if test="position() &lt; count(../value)"><xsl:text> || </xsl:text></xsl:if>
			</xsl:for-each>)
		</xsl:when>
		<xsl:when test="$pointcuttype='WithinCodePointCut'">(
			<xsl:for-each select="$pointcutinstance/slot[@definingFeature=$operationfeatureID]/value">
				withincode(<xsl:call-template name="writeOperation"><xsl:with-param name="operation" select="@element"/></xsl:call-template>)
				<xsl:if test="position() &lt; count(../value)"><xsl:text> || </xsl:text></xsl:if>
			</xsl:for-each>)
		</xsl:when>
		<xsl:when test="$pointcuttype='InitializationPointCut'">(
			<xsl:for-each select="$pointcutinstance/slot[@definingFeature=$operationfeatureID]/value">
				initialization(<xsl:call-template name="writeConstructor"><xsl:with-param name="operation" select="@element"/></xsl:call-template>)
				<xsl:if test="position() &lt; count(../value)"><xsl:text> || </xsl:text></xsl:if>
			</xsl:for-each>)
		</xsl:when>
		<xsl:when test="$pointcuttype='PreInitializationPointCut'">(
			<xsl:for-each select="$pointcutinstance/slot[@definingFeature=$operationfeatureID]/value">
				preinitialization(<xsl:call-template name="writeConstructor"><xsl:with-param name="operation" select="@element"/></xsl:call-template>)
				<xsl:if test="position() &lt; count(../value)"><xsl:text> || </xsl:text></xsl:if>
			</xsl:for-each>)
		</xsl:when>
		<xsl:when test="$pointcuttype='ExceptionPointCut'">(
			<xsl:for-each select="$pointcutinstance/slot[@definingFeature=$typefeatureID]/value">
				handler(<xsl:call-template name="writeType"><xsl:with-param name="type" select="@element"/></xsl:call-template>)
				<xsl:if test="position() &lt; count(../value)"><xsl:text> || </xsl:text></xsl:if>
			</xsl:for-each>)
		</xsl:when>
		<xsl:when test="$pointcuttype='WithinPointCut'">(
			<xsl:for-each select="$pointcutinstance/slot[@definingFeature=$typefeatureID]/value">
				within(<xsl:call-template name="writeType"><xsl:with-param name="type" select="@element"/></xsl:call-template>)
				<xsl:if test="position() &lt; count(../value)"><xsl:text> || </xsl:text></xsl:if>
			</xsl:for-each>)
		</xsl:when>
		<xsl:when test="$pointcuttype='TargetPointCut'">(
			<xsl:for-each select="$pointcutinstance/slot[@definingFeature=$typefeatureID]/value">
			target(
				<xsl:variable name="currentpos" select="position()"/>
				<xsl:choose>
					<xsl:when test="count($pointcutinstance/slot[@definingFeature=$argnamesfeatureID]/value[position()=$currentpos]) &gt; 0">
					<xsl:value-of select="$pointcutinstance/slot[@definingFeature=$argnamesfeatureID]/value[position()=$currentpos]/@value"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="writeType"><xsl:with-param name="type" select="@element"/></xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			) <xsl:if test="position() &lt; count(../value)"><xsl:text> || </xsl:text></xsl:if>
			</xsl:for-each>)
		</xsl:when>
		<xsl:when test="$pointcuttype='ThisPointCut'">(
			<xsl:for-each select="$pointcutinstance/slot[@definingFeature=$typefeatureID]/value">
			this(
				<xsl:variable name="currentpos" select="position()"/>
				<xsl:choose>
					<xsl:when test="count($pointcutinstance/slot[@definingFeature=$argnamesfeatureID]/value[position()=$currentpos]) &gt; 0">
					<xsl:value-of select="$pointcutinstance/slot[@definingFeature=$argnamesfeatureID]/value[position()=$currentpos]/@value"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="writeType"><xsl:with-param name="type" select="@element"/></xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			) <xsl:if test="position() &lt; count(../value)"><xsl:text> || </xsl:text></xsl:if>
			</xsl:for-each>)
		</xsl:when>
		<xsl:when test="$pointcuttype='ArgsPointCut'">
			args(
			<xsl:for-each select="$pointcutinstance/slot[@definingFeature=$typefeatureID]/value">
				<xsl:variable name="currentpos" select="position()"/>
				<xsl:choose>
					<xsl:when test="count($pointcutinstance/slot[@definingFeature=$argnamesfeatureID]/value[position()=$currentpos]) &gt; 0">
					<xsl:value-of select="$pointcutinstance/slot[@definingFeature=$argnamesfeatureID]/value[position()=$currentpos]/@value"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="writeType"><xsl:with-param name="type" select="@element"/></xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:if test="position() &lt; count(../value)"><xsl:text>, </xsl:text></xsl:if>
			</xsl:for-each>
			)
		</xsl:when>
		<xsl:when test="$pointcuttype='StaticInitializationPointCut'">(
			<xsl:for-each select="$pointcutinstance/slot[@definingFeature=$typefeatureID]/value">
				staticinitialization(<xsl:call-template name="writeType"><xsl:with-param name="type" select="@element"/></xsl:call-template>)
				<xsl:if test="position() &lt; count(../value)"><xsl:text> || </xsl:text></xsl:if>
			</xsl:for-each>)
		</xsl:when>
		<xsl:when test="$pointcuttype='AdviceExecutionPointCut'">
			adviceexecution()
		</xsl:when>
		<xsl:when test="$pointcuttype='CFlowPointCut'">(
			<xsl:for-each select="$pointcutinstance/slot[@definingFeature=$selectedpointcutfeatureID]/value">
				cflow(<xsl:call-template name="writePointCut"><xsl:with-param name="pointcut" select="@element"/></xsl:call-template>)
				<xsl:if test="position() &lt; count(../value)"><xsl:text> || </xsl:text></xsl:if>
			</xsl:for-each>)
		</xsl:when>
		<xsl:when test="$pointcuttype='CFlowBelowPointCut'">(
			<xsl:for-each select="$pointcutinstance/slot[@definingFeature=$selectedpointcutfeatureID]/value">
				cflowbelow(<xsl:call-template name="writePointCut"><xsl:with-param name="pointcut" select="@element"/></xsl:call-template>)
				<xsl:if test="position() &lt; count(../value)"><xsl:text> || </xsl:text></xsl:if>
			</xsl:for-each>)
		</xsl:when>
		<xsl:when test="$pointcuttype='SetPointCut'">(
			<xsl:for-each select="$pointcutinstance/slot[@definingFeature=$fieldfeatureID]/value">
				set(<xsl:call-template name="writeField"><xsl:with-param name="field" select="@element"/></xsl:call-template>)
				<xsl:if test="position() &lt; count(../value)"><xsl:text> || </xsl:text></xsl:if>
			</xsl:for-each>)
		</xsl:when>
		<xsl:when test="$pointcuttype='GetPointCut'">(
			<xsl:for-each select="$pointcutinstance/slot[@definingFeature=$fieldfeatureID]/value">
				get(<xsl:call-template name="writeField"><xsl:with-param name="field" select="@element"/></xsl:call-template>)
				<xsl:if test="position() &lt; count(../value)"><xsl:text> || </xsl:text></xsl:if>
			</xsl:for-each>)
		</xsl:when>
		<xsl:when test="$pointcuttype='CompositePointCut'">
			<xsl:variable name="compositiontype" select="//ownedLiteral[@xmi:id=$pointcutinstance/slot[@definingFeature=$compositiontypefeatureID]/value/@instance]/@name"/>
			(<xsl:for-each select="$pointcutinstance/slot[@definingFeature=$composeefeatureID]/value">
				<xsl:call-template name="writePointCut"><xsl:with-param name="pointcut" select="@element"/></xsl:call-template>
				<xsl:if test="position() &lt; count(../value)">
					<xsl:choose>
						<xsl:when test="$compositiontype='And'"><xsl:text> &amp;&amp; </xsl:text></xsl:when>
						<xsl:when test="$compositiontype='Or'"><xsl:text> || </xsl:text></xsl:when>
						<xsl:when test="$compositiontype='Not'"><xsl:text> ! </xsl:text></xsl:when>
					</xsl:choose>
				</xsl:if>
			</xsl:for-each>)
		</xsl:when>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="processPointCutContext">
		<xsl:param name="pointcuttype"/>
		<xsl:param name="pointcutinstance"/>
		<xsl:variable name="profilestereotypeID" select="//ownedMember[@xmi:type='uml:Profile' and @name='aspectJ']/@xmi:id"/>
		<xsl:variable name="typefeatureID" select="//ownedMember[@xmi:id=$profilestereotypeID]/ownedStereotype[@name='TypePointCut']/ownedAttribute[@name='type']/@xmi:id"/>
		<xsl:variable name="argnamesfeatureID" select="//ownedMember[@xmi:id=$profilestereotypeID]/ownedStereotype[@name='ContextExposingPointCut']/ownedAttribute[@name='argNames']/@xmi:id"/>
		<xsl:variable name="selectedpointcutfeatureID" select="//ownedMember[@xmi:id=$profilestereotypeID]/ownedStereotype[@name='PointCutPointCut']/ownedAttribute[@name='selectedPointCut']/@xmi:id"/>
		<xsl:variable name="composeefeatureID" select="//ownedMember[@xmi:id=$profilestereotypeID]/ownedStereotype[@name='CompositePointCut']/ownedAttribute[@name='composee']/@xmi:id"/>
		<xsl:variable name="compositiontypefeatureID" select="//ownedMember[@xmi:id=$profilestereotypeID]/ownedStereotype[@name='CompositePointCut']/ownedAttribute[@name='compositionType']/@xmi:id"/>
		<xsl:choose>
		<xsl:when test="$pointcuttype='TargetPointCut'">
			<xsl:for-each select="$pointcutinstance/slot[@definingFeature=$typefeatureID]/value">
				<xsl:variable name="currentpos" select="position()"/>
				<xsl:choose>
					<xsl:when test="count($pointcutinstance/slot[@definingFeature=$argnamesfeatureID]/value[position()=$currentpos]) &gt; 0">
						<xsl:choose>
							<xsl:when test="count(@element)=1">
								<xsl:call-template name="writeType"><xsl:with-param name="type" select="@element"/></xsl:call-template>
							</xsl:when>
							<xsl:when test="count(element)=1">
								<xsl:value-of select="translate(normalize-space(translate(translate(element/xmi:Extension/referenceExtension/@referentPath,' ','_'),':',' ')),' ','.')"/>
							</xsl:when>
						</xsl:choose>
						<xsl:text> </xsl:text>
						<xsl:value-of select="$pointcutinstance/slot[@definingFeature=$argnamesfeatureID]/value[position()=$currentpos]/@value"/>
						<xsl:if test="position() &lt; count(../value)"><xsl:text>, </xsl:text></xsl:if>
					</xsl:when>
				</xsl:choose>						
			</xsl:for-each>
		</xsl:when>
		<xsl:when test="$pointcuttype='ThisPointCut'">
			<xsl:for-each select="$pointcutinstance/slot[@definingFeature=$typefeatureID]/value">
				<xsl:variable name="currentpos" select="position()"/>
				<xsl:choose>
					<xsl:when test="count($pointcutinstance/slot[@definingFeature=$argnamesfeatureID]/value[position()=$currentpos]) &gt; 0">
					<xsl:choose>
						<xsl:when test="count(@element)=1">
							<xsl:call-template name="writeType"><xsl:with-param name="type" select="@element"/></xsl:call-template>
						</xsl:when>
						<xsl:when test="count(element)=1">
							<xsl:value-of select="translate(normalize-space(translate(translate(element/xmi:Extension/referenceExtension/@referentPath,' ','_'),':',' ')),' ','.')"/>
						</xsl:when>
					</xsl:choose>
					<xsl:text> </xsl:text>
					<xsl:value-of select="$pointcutinstance/slot[@definingFeature=$argnamesfeatureID]/value[position()=$currentpos]/@value"/>
					<xsl:if test="position() &lt; count(../value)"><xsl:text>, </xsl:text></xsl:if>
					</xsl:when>
				</xsl:choose>						
			</xsl:for-each>
		</xsl:when>
		<xsl:when test="$pointcuttype='ArgsPointCut'">
			<xsl:for-each select="$pointcutinstance/slot[@definingFeature=$typefeatureID]/value">
				<xsl:variable name="currentpos" select="position()"/>
				<xsl:choose>
					<xsl:when test="count($pointcutinstance/slot[@definingFeature=$argnamesfeatureID]/value[position()=$currentpos]) &gt; 0">
						<xsl:choose>
							<xsl:when test="count(@element)=1">
								<xsl:call-template name="writeType"><xsl:with-param name="type" select="@element"/></xsl:call-template>
							</xsl:when>
							<xsl:when test="count(element)=1">
								<xsl:value-of select="translate(normalize-space(translate(translate(element/xmi:Extension/referenceExtension/@referentPath,' ','_'),':',' ')),' ','.')"/>
							</xsl:when>
						</xsl:choose>
						<xsl:text> </xsl:text>
						<xsl:value-of select="$pointcutinstance/slot[@definingFeature=$argnamesfeatureID]/value[position()=$currentpos]/@value"/>
						<xsl:if test="position() &lt; count(../value)"><xsl:text>, </xsl:text></xsl:if>
					</xsl:when>
				</xsl:choose>						
			</xsl:for-each>
		</xsl:when>
		<xsl:when test="$pointcuttype='CompositePointCut'">
			<xsl:variable name="compositiontype" select="//ownedLiteral[@xmi:id=$pointcutinstance/slot[@definingFeature=$compositiontypefeatureID]/value/@instance]/@name"/>
			<xsl:for-each select="$pointcutinstance/slot[@definingFeature=$composeefeatureID]/value">
				<xsl:variable name="nextPointCutInstanceID" select="@element"/>			
				<xsl:variable name="nextpointcut" select="//ownedAttribute[@xmi:id=$nextPointCutInstanceID]"/>
				<xsl:variable name="profilestereotypeID" select="//ownedMember[@xmi:type='uml:Profile' and @name='aspectJ']/@xmi:id"/>
				<xsl:variable name="nextpointcutstereotypeID" select="$nextpointcut/xmi:Extension/modelExtension/appliedStereotypeInstance/classifier/@xmi:idref"/>
				<xsl:variable name="nextpointcuttype" select="//ownedMember[@xmi:id=$profilestereotypeID]/ownedStereotype[@xmi:id=$nextpointcutstereotypeID and ownedAttribute/@name='base_StructuralFeature']/@name"/>
				<xsl:variable name="nextpointcutinstance" select="$nextpointcut/xmi:Extension/modelExtension/appliedStereotypeInstance[classifier/@xmi:idref=$nextpointcutstereotypeID]"/>
				<xsl:call-template name="processPointCutContext">
					<xsl:with-param name="pointcutinstance" select="$nextpointcutinstance"/>
					<xsl:with-param name="pointcuttype" select="$nextpointcuttype"/>
				</xsl:call-template>
				<xsl:if test="(position() &lt; count(../value)) and ($nextpointcuttype='TargetPointCut' or $nextpointcuttype='ThisPointCut' or $nextpointcuttype='ArgsPointCut')"><xsl:text>, </xsl:text></xsl:if>
			</xsl:for-each>
		</xsl:when>
		<xsl:otherwise>
		</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

</xsl:stylesheet>

