import Tkinter
import tkFileDialog
import os
from utils import is_posint


def on_closing():
    pass


class PredictConfigurationDialog(object):

    def go_action(self):
        self.top.grab_release()
        self.top.quit()
        self.top.withdraw()

    def __init__(self, pconf):
        p = 5

        self.outputpathVar = Tkinter.StringVar(value="")
        self.numPStepsVar = Tkinter.StringVar(value='1')
        self.eocDetectVar = Tkinter.BooleanVar(value=True)

        if pconf is not None:
            self.set(pconf)

        self.top = Tkinter.Toplevel()
        self.top.title("Configuration Dialog")
        self.top.resizable(False, False)
        self.top.protocol("WM_DELETE_WINDOW", on_closing)

        self.top.configure(padx=p, pady=p)
        self.top.resizable(False, False)

        intCheck = self.top.register(is_posint)

        mainFrame = Tkinter.LabelFrame(self.top, text="Prediction Config", padx=p, pady=p)
        mainFrame.grid(row=0, columnspan=3, sticky="WE")

        lbl = Tkinter.Label(mainFrame, text="Output folder:")
        lbl.grid(row=0, column=0)
        lbl = Tkinter.Label(mainFrame, textvariable=self.outputpathVar, anchor=Tkinter.W, padx=p, pady=p, width=50)
        lbl.grid(row=0, column=1, sticky=Tkinter.W)

        btn = Tkinter.Button(mainFrame, text="Set folder", padx=p, pady=p)
        btn['command'] = self.folder_action
        btn.grid(row=0, column=2, columnspan=2)

        lbl = Tkinter.Label(mainFrame, text="Steps to predict:")
        lbl.grid(row=1, column=0)
        entry = Tkinter.Entry(mainFrame, textvariable=self.numPStepsVar, validate='key', validatecommand=(intCheck, '%P'))
        entry.grid(row=1, column=1, sticky=Tkinter.W)

        lbl = Tkinter.Label(mainFrame, text="Detect End-of-Case?")
        lbl.grid(row=2, column=0)
        chkbtn = Tkinter.Checkbutton(mainFrame, variable=self.eocDetectVar)
        chkbtn.grid(row=2, column=1, sticky=Tkinter.W)

        btn = Tkinter.Button(self.top, text="OK", padx=p, pady=p)
        btn['command'] = self.go_action
        btn.grid(row=1, column=1)

    def folder_action(self):
        # Select a directory (either point to an existing one or specify a new one, which we will create in the next step
        p = tkFileDialog.askdirectory(title="Select directory for config, log, and result files", mustexist=False)
        if len(p) != 0:
            if not os.path.isdir(p):
                os.makedirs(p)
            self.outputpathVar.set(p)

    def set(self, pconf):
        if pconf is not None:
            self.outputpathVar.set(pconf.outputPath)
            self.numPStepsVar.set(pconf.numPSteps)
            self.eocDetectVar.set(pconf.eocDetect)

    def show(self):
        self.top.grab_set()
        self.top.mainloop()


class PredictConfig:
    def __init__(self):
        self.outputPath = os.getcwd()
        self.numPSteps = 1
        self.eocDetect = True
        pass

    @classmethod
    def fromDialog(cls, dlg):
        c = PredictConfig()
        c.outputPath = dlg.outputpathVar.get()
        c.numPSteps = int(dlg.numPStepsVar.get())
        c.eocDetect = bool(dlg.eocDetectVar.get())
        return c

    @classmethod
    def fromParameters(cls, outputPath, numPSteps):
        c = PredictConfig()
        c.outputPath = outputPath
        c.numPSteps = numPSteps
        c.eocDetect = True
        return c
