import Tkinter
import ttk
import re
import math


def on_closing():
    pass


class TrainingProgressBox:
    def __init__(self, targNames, xespath):
        p = 5

        self.root = Tkinter.Toplevel()
        self.root.title("Training Graph")
        self.root.resizable(False, False)
        self.root.protocol("WM_DELETE_WINDOW", on_closing)

        self.frame = Tkinter.Frame(self.root)
        self.frame.configure(padx=p, pady=p)

        self.CurrentOpVar = Tkinter.StringVar(value='')
        self.eventsPerSecondVar = Tkinter.StringVar(value='0.0')
        self.learningRateVar = Tkinter.StringVar(value='0.0')

        xesPathFrame = Tkinter.LabelFrame(self.root, text="Log", padx=p, pady=p)
        xesPathFrame.grid(sticky="WE")
        progressFrame = Tkinter.LabelFrame(self.root, text="Progress", padx=p, pady=p)
        progressFrame.grid(sticky="WE")
        perfFrame = Tkinter.LabelFrame(self.root, text="Training Performance", padx=p, pady=p)
        perfFrame.grid(sticky="WE")

        lbl = Tkinter.Label(xesPathFrame, text="XES File:")
        lbl.grid(row=0, column=0)
        lbl = Tkinter.Label(xesPathFrame, text=xespath, padx=p, pady=p)
        lbl.grid(row=0, column=1, sticky=Tkinter.W)

        lbl = Tkinter.Label(progressFrame, text="Progress:", padx=p, pady=p)
        lbl.grid(row=0, column=0, sticky=Tkinter.W)
        self.progressBar = ttk.Progressbar(progressFrame, orient="horizontal", length=200, mode="indeterminate")
        self.progressBar.grid(row=0, column=1)
        self.progressBar.start()
        lbl = Tkinter.Label(progressFrame, text="Current Op:", padx=p, pady=p)
        lbl.grid(row=1, column=0, sticky=Tkinter.W)
        lbl = Tkinter.Label(progressFrame, textvariable=self.CurrentOpVar, padx=p, pady=p)
        lbl.grid(row=1, column=1, sticky=Tkinter.W)
        lbl = Tkinter.Label(progressFrame, text="Training rate (events per second):", padx=p, pady=p)
        lbl.grid(row=2, column=0, sticky=Tkinter.W)
        lbl = Tkinter.Label(progressFrame, textvariable=self.eventsPerSecondVar, padx=p, pady=p)
        lbl.grid(row=2, column=1, sticky=Tkinter.W)
        lbl = Tkinter.Label(progressFrame, text="Learning rate:", padx=p, pady=p)
        lbl.grid(row=3, column=0, sticky=Tkinter.W)
        lbl = Tkinter.Label(progressFrame, textvariable=self.learningRateVar, padx=p, pady=p)
        lbl.grid(row=3, column=1, sticky=Tkinter.W)

        self.percCorrectPredVar = dict()
        self.meanLossVar = dict()
        for row, targName in enumerate(targNames):
            self.percCorrectPredVar[targName] = Tkinter.StringVar(value='0.0')
            self.meanLossVar[targName] = Tkinter.StringVar(value='0.0')

            lbl = Tkinter.Label(perfFrame, text=targName, background="yellow", padx=p, pady=p)
            lbl.grid(row=row, column=0)
            lbl = Tkinter.Label(perfFrame, text="Percent correct predictions:", padx=p, pady=p)
            lbl.grid(row=row, column=1, sticky=Tkinter.W)
            lbl = Tkinter.Label(perfFrame, textvariable=self.percCorrectPredVar[targName], padx=p, pady=p)
            lbl.grid(row=row, column=2, sticky=Tkinter.W)
            lbl = Tkinter.Label(perfFrame, text="Mean loss:", padx=p, pady=p)
            lbl.grid(row=row, column=3, sticky=Tkinter.W)
            lbl = Tkinter.Label(perfFrame, textvariable=self.meanLossVar[targName], padx=p, pady=p)
            lbl.grid(row=row, column=4, sticky=Tkinter.W)

        self.root.wm_deiconify()
        self.root.grab_set()
        self.frame.update()

    def update(self, message, eventsPerSecond, learningRate, percCorrectPred, meanLoss):
        self.CurrentOpVar.set(message)
        self.eventsPerSecondVar.set('{:d}'.format(int(math.ceil(eventsPerSecond))))
        self.learningRateVar.set('{:4.3f}'.format(learningRate))
        for (name, value) in percCorrectPred.iteritems():
            self.percCorrectPredVar[name].set('{:06.3f}'.format(value))
        for (name, value) in meanLoss.iteritems():
            self.meanLossVar[name].set('{:010.6f}'.format(value))
        self.frame.update()

    def updateMessage(self, message):
        self.CurrentOpVar.set(message)
        self.frame.update()

    def makeTick(self):
        self.frame.update()

    def destroy(self):
        self.root.grab_release()
        self.root.destroy()
